import sys
import math

sys.setrecursionlimit(2000)


def solve():
    def input_gen():
        for line in sys.stdin:
            for token in line.split():
                yield token

    iterator = input_gen()

    try:
        t_str = next(iterator)
        t = int(t_str)
    except StopIteration:
        return

    def get_hull(points):
        points.sort()
        if not points:
            return []

        lower = []
        for p in points:
            while len(lower) >= 2:
                o = lower[-2]
                a = lower[-1]
                val = (a[0] - o[0]) * (p[1] - o[1]) - (a[1] - o[1]) * (p[0] - o[0])
                if val <= 0:
                    lower.pop()
                else:
                    break
            lower.append(p)

        upper = []
        for p in reversed(points):
            while len(upper) >= 2:
                o = upper[-2]
                a = upper[-1]
                val = (a[0] - o[0]) * (p[1] - o[1]) - (a[1] - o[1]) * (p[0] - o[0])
                if val <= 0:
                    upper.pop()
                else:
                    break
            upper.append(p)

        return lower[:-1] + upper[:-1]

    def check(hullA, hullB):
        if not hullA or not hullB:
            return True

        low = 0.0
        high = 1.57079632679  # pi/2

        for _ in range(35):
            m1 = low + (high - low) / 3
            m2 = high - (high - low) / 3

            c1, s1 = math.cos(m1), math.sin(m1)
            c2, s2 = math.cos(m2), math.sin(m2)

            max_a1 = -1e18
            for px, py in hullA:
                val = px * c1 + py * s1
                if val > max_a1: max_a1 = val

            min_b1 = 1e18
            for px, py in hullB:
                val = px * c1 + py * s1
                if val < min_b1: min_b1 = val

            f1 = min_b1 - max_a1

            max_a2 = -1e18
            for px, py in hullA:
                val = px * c2 + py * s2
                if val > max_a2: max_a2 = val

            min_b2 = 1e18
            for px, py in hullB:
                val = px * c2 + py * s2
                if val < min_b2: min_b2 = val

            f2 = min_b2 - max_a2

            if f1 >= 0 or f2 >= 0:
                return True

            if f1 < f2:
                low = m1
            else:
                high = m2

        mid = (low + high) * 0.5
        c, s = math.cos(mid), math.sin(mid)

        max_a = -1e18
        for px, py in hullA:
            val = px * c + py * s
            if val > max_a: max_a = val

        min_b = 1e18
        for px, py in hullB:
            val = px * c + py * s
            if val < min_b: min_b = val

        return (min_b - max_a) >= -1e-7

    out = []

    for _ in range(t):
        try:
            n = int(next(iterator))
        except StopIteration:
            break

        x1s = [0] * n
        y1s = [0] * n
        x2s = [0] * n
        y2s = [0] * n

        for i in range(n):
            x1s[i] = int(next(iterator))
            y1s[i] = int(next(iterator))
            x2s[i] = int(next(iterator))
            y2s[i] = int(next(iterator))

        if n == 1:
            out.append("Yes")
            continue

        ptsA1 = []
        ptsB1 = []
        for i in range(n):
            ptsA1.append((x1s[i], y1s[i]))
            ptsB1.append((x2s[i], y2s[i]))

        hullA1 = get_hull(ptsA1)
        hullB1 = get_hull(ptsB1)

        if check(hullA1, hullB1):
            out.append("Yes")
            continue

        ptsA2 = []
        ptsB2 = []
        for i in range(n):
            ptsA2.append((-x2s[i], y1s[i]))
            ptsB2.append((-x1s[i], y2s[i]))

        hullA2 = get_hull(ptsA2)
        hullB2 = get_hull(ptsB2)

        if check(hullA2, hullB2):
            out.append("Yes")
        else:
            out.append("No")

    sys.stdout.write('\n'.join(out) + '\n')


if __name__ == '__main__':
    solve()