import sys

sys.setrecursionlimit(2000)

def solve():
    try:
        line1 = sys.stdin.readline()
        if not line1:
            return
        m = int(line1)

        line2 = sys.stdin.readline()
        if not line2:
            return
        l, r = map(int, line2.split())
    except ValueError:
        return

    limit = r + 1

    lp = [0] * limit
    primes = []

    aux = [1] * limit
    e = [0] * limit
    valid = [False] * limit

    valid[1] = True

    for i in range(2, limit):
        if lp[i] == 0:
            lp[i] = i
            primes.append(i)
            e[i] = 1
            aux[i] = 1
            valid[i] = True

        for p in primes:
            if p > lp[i] or i * p >= limit:
                break

            x = i * p
            lp[x] = p

            if p == lp[i]:
                e[x] = e[i] + 1
                aux[x] = aux[i]
                if (e[x] & 1) and valid[aux[x]]:
                    valid[x] = True
                else:
                    valid[x] = False
            else:
                e[x] = 1
                aux[x] = i
                valid[x] = valid[i]

    pref = [0] * (limit + 1)
    for i in range(1, limit):
        pref[i] = pref[i - 1] + (1 if valid[i] else 0)

    for start in range(l, r - m + 2):
        end = start + m - 1
        count = pref[end] - pref[start - 1]

        if count == m:
            print(*(range(start, end + 1)))
            return

    print("-1")

if __name__ == '__main__':
    solve()