import sys


def solve_one_test(rects):
    n = len(rects)
    if n == 1:
        return True

    min_x2, max_x1 = float('inf'), float('-inf')
    min_y2, max_y1 = float('inf'), float('-inf')

    for x1, y1, x2, y2 in rects:
        max_x1 = max(max_x1, x1)
        min_x2 = min(min_x2, x2)
        max_y1 = max(max_y1, y1)
        min_y2 = min(min_y2, y2)

    if max_x1 <= min_x2:
        return True
    if max_y1 <= min_y2:
        return True

    max_y1_val = float('-inf')
    min_y2_val = float('inf')
    max_y1_x2 = 0
    min_y2_x1 = 0

    for x1, y1, x2, y2 in rects:
        if y1 > max_y1_val:
            max_y1_val = y1
            max_y1_x2 = x2
        elif y1 == max_y1_val:
            max_y1_x2 = max(max_y1_x2, x2)

        if y2 < min_y2_val:
            min_y2_val = y2
            min_y2_x1 = x1
        elif y2 == min_y2_val:
            min_y2_x1 = min(min_y2_x1, x1)

    min_y1_val = float('inf')
    max_y2_val = float('-inf')
    min_y1_x2 = 0
    max_y2_x1 = 0

    for x1, y1, x2, y2 in rects:
        if y1 < min_y1_val:
            min_y1_val = y1
            min_y1_x2 = x2
        elif y1 == min_y1_val:
            min_y1_x2 = min(min_y1_x2, x2)

        if y2 > max_y2_val:
            max_y2_val = y2
            max_y2_x1 = x1
        elif y2 == max_y2_val:
            max_y2_x1 = max(max_y2_x1, x1)

    k_lower = float('-inf')
    k_upper = float('inf')

    for x1, y1, x2, y2 in rects:
        if x2 > min_y2_x1:
            val = (y1 - min_y2_val) / (x2 - min_y2_x1)
            if val > k_lower:
                k_lower = val

    for x1, y1, x2, y2 in rects:
        if max_y1_x2 < x1:
            val = (max_y1_val - y2) / (max_y1_x2 - x1)
            if val < k_upper:
                k_upper = val

    for x1, y1, x2, y2 in rects:
        if x2 < min_y2_x1:
            val = (y1 - min_y2_val) / (x2 - min_y2_x1)
            if val < k_upper:
                k_upper = val

    for x1, y1, x2, y2 in rects:
        if max_y1_x2 > x1:
            val = (max_y1_val - y2) / (max_y1_x2 - x1)
            if val > k_lower:
                k_lower = val

    if k_lower <= k_upper and k_upper >= 0:
        return True

    m_lower = float('-inf')
    m_upper = float('inf')

    for x1_i, y1_i, x2_i, y2_i in rects:
        for x1_j, y1_j, x2_j, y2_j in rects:
            if x2_j > x1_i:
                val = (y1_i - y2_j) / (x2_j - x1_i)
                if val > m_lower:
                    m_lower = val

    for x1_i, y1_i, x2_i, y2_i in rects:
        for x1_j, y1_j, x2_j, y2_j in rects:
            if x2_j < x1_i:
                val = (y1_i - y2_j) / (x2_j - x1_i)
                if val < m_upper:
                    m_upper = val

    if m_lower <= m_upper and m_upper >= 0:
        return True

    return False


def main():
    import sys
    data = sys.stdin.read().split()

    t = int(data[0])
    idx = 1
    results = []

    for _ in range(t):
        n = int(data[idx])
        idx += 1

        rects = []
        for __ in range(n):
            x1 = int(data[idx]);
            y1 = int(data[idx + 1])
            x2 = int(data[idx + 2]);
            y2 = int(data[idx + 3])
            idx += 4
            rects.append((x1, y1, x2, y2))

        if solve_one_test(rects):
            results.append("Yes")
        else:
            results.append("No")

    print("\n".join(results))


if __name__ == "__main__":
    main()
