import sys

input = sys.stdin.readline


def solve(rects):
    hL = -10 ** 30
    hR = 10 ** 30
    vL = -10 ** 30
    vR = 10 ** 30
    d1L = -10 ** 30
    d1R = 10 ** 30
    d2L = -10 ** 30
    d2R = 10 ** 30

    for (x1, y1, x2, y2) in rects:
        if x1 > x2: x1, x2 = x2, x1
        if y1 > y2: y1, y2 = y2, y1

        hL = max(hL, y1)
        hR = min(hR, y2)

        vL = max(vL, x1)
        vR = min(vR, x2)

        d1L = max(d1L, y1 - x2)
        d1R = min(d1R, y2 - x1)

        d2L = max(d2L, y1 + x1)
        d2R = min(d2R, y2 + x2)

    return (hL <= hR) or (vL <= vR) or (d1L <= d1R) or (d2L <= d2R)


def main():
    import sys
    data = sys.stdin.buffer.read().split()
    it = iter(data)
    T = int(next(it))
    out = []
    for _ in range(T):
        n = int(next(it))
        rects = []
        for i in range(n):
            x1 = int(next(it))
            y1 = int(next(it))
            x2 = int(next(it))
            y2 = int(next(it))
            rects.append((x1, y1, x2, y2))
        out.append("Yes" if solve(rects) else "No")
    sys.stdout.write("\n".join(out))


main()