import sys

sys.setrecursionlimit(2000)


def solve():
    input_data = sys.stdin.read().split()

    if not input_data:
        return

    iterator = iter(input_data)
    try:
        T_str = next(iterator)
        T = int(T_str)
    except StopIteration:
        return

    for _ in range(T):
        try:
            n = int(next(iterator))
        except StopIteration:
            break

        x1 = [0] * n
        y1 = [0] * n
        x2 = [0] * n
        y2 = [0] * n

        glob_min_x2 = 2000000000
        glob_max_x1 = -1
        glob_min_y2 = 2000000000
        glob_max_y1 = -1

        for i in range(n):
            X1 = int(next(iterator))
            Y1 = int(next(iterator))
            X2 = int(next(iterator))
            Y2 = int(next(iterator))

            x1[i] = X1
            y1[i] = Y1
            x2[i] = X2
            y2[i] = Y2

            if X2 < glob_min_x2: glob_min_x2 = X2
            if X1 > glob_max_x1: glob_max_x1 = X1
            if Y2 < glob_min_y2: glob_min_y2 = Y2
            if Y1 > glob_max_y1: glob_max_y1 = Y1

        if glob_max_x1 <= glob_min_x2:
            print("Yes")
            continue

        if glob_max_y1 <= glob_min_y2:
            print("Yes")
            continue

        l, r = 0.0, 2e9

        for _ in range(60):
            m1 = l + (r - l) / 3
            m2 = r - (r - l) / 3

            mn1 = 1e18
            mx1 = -1e18
            for i in range(n):
                u = y2[i] - m1 * x1[i]
                v = y1[i] - m1 * x2[i]
                if u < mn1: mn1 = u
                if v > mx1: mx1 = v
            res1 = mn1 - mx1

            mn2 = 1e18
            mx2 = -1e18
            for i in range(n):
                u = y2[i] - m2 * x1[i]
                v = y1[i] - m2 * x2[i]
                if u < mn2: mn2 = u
                if v > mx2: mx2 = v
            res2 = mn2 - mx2

            if res1 < res2:
                l = m1
            else:
                r = m2

        final_a = l
        mn = 1e18
        mx = -1e18
        for i in range(n):
            u = y2[i] - final_a * x1[i]
            v = y1[i] - final_a * x2[i]
            if u < mn: mn = u
            if v > mx: mx = v

        if mn - mx >= -1e-5:
            print("Yes")
            continue

        l, r = 0.0, 2e9
        for _ in range(60):
            m1 = l + (r - l) / 3
            m2 = r - (r - l) / 3

            mn1 = 1e18
            mx1 = -1e18
            for i in range(n):
                u = y2[i] + m1 * x2[i]
                v = y1[i] + m1 * x1[i]
                if u < mn1: mn1 = u
                if v > mx1: mx1 = v
            res1 = mn1 - mx1

            mn2 = 1e18
            mx2 = -1e18
            for i in range(n):
                u = y2[i] + m2 * x2[i]
                v = y1[i] + m2 * x1[i]
                if u < mn2: mn2 = u
                if v > mx2: mx2 = v
            res2 = mn2 - mx2

            if res1 < res2:
                l = m1
            else:
                r = m2

        final_k = l
        mn = 1e18
        mx = -1e18
        for i in range(n):
            u = y2[i] + final_k * x2[i]
            v = y1[i] + final_k * x1[i]
            if u < mn: mn = u
            if v > mx: mx = v

        if mn - mx >= -1e-5:
            print("Yes")
        else:
            print("No")


if __name__ == '__main__':
    solve()