import sys, math, heapq
data = list(map(int, sys.stdin.buffer.read().split()))
it = iter(data)
T = next(it)
out_lines = []
EPS = 1e-12
for _ in range(T):
    n = next(it)
    rects = []
    for i in range(n):
        x1 = next(it); y1 = next(it); x2 = next(it); y2 = next(it)
        if x1 > x2: x1, x2 = x2, x1
        if y1 > y2: y1, y2 = y2, y1
        rects.append((x1,y1,x2,y2))
    events = []
    for i,(x1,y1,x2,y2) in enumerate(rects):
        pts = [(x1,y1),(x1,y2),(x2,y1),(x2,y2)]
        for a in range(4):
            xa,ya = pts[a]
            for b in range(a+1,4):
                xb,yb = pts[b]
                dx = xa - xb
                dy = ya - yb
                if dx==0 and dy==0: continue
                ang = math.atan2(-dx, dy)
                if ang < 0: ang += math.pi
                if ang >= math.pi: ang -= math.pi
                events.append((ang, i))
    events.sort(key=lambda x: x[0])
    cur_min = [0.0]*n
    cur_max = [0.0]*n
    min_heap = []
    max_heap = []
    def proj_bounds_at(i,theta):
        x1,y1,x2,y2 = rects[i]
        c = math.cos(theta); s = math.sin(theta)
        p1 = x1*c + y1*s
        p2 = x1*c + y2*s
        p3 = x2*c + y1*s
        p4 = x2*c + y2*s
        mn = p1
        if p2<mn: mn=p2
        if p3<mn: mn=p3
        if p4<mn: mn=p4
        mx = p1
        if p2>mx: mx=p2
        if p3>mx: mx=p3
        if p4>mx: mx=p4
        return mn, mx
    for i in range(n):
        mn,mx = proj_bounds_at(i, 0.0)
        cur_min[i] = mn
        cur_max[i] = mx
        heapq.heappush(min_heap, (mn, i))
        heapq.heappush(max_heap, (mx, i))
    def get_global_L():
        while min_heap:
            val,i = min_heap[-1] if False else None
            break
        while min_heap and cur_min[min_heap[0][1]] != min_heap[0][0]:
            heapq.heappop(min_heap)
        if not min_heap: return -1e100
        return min_heap[0][0]
    def get_global_R():
        while max_heap and cur_max[max_heap[0][1]] != max_heap[0][0]:
            heapq.heappop(max_heap)
        if not max_heap: return 1e100
        return max_heap[0][0]
    min_of_mins_heap = []
    max_of_mins = []
    for i in range(n):
        heapq.heappush(max_of_mins, (-cur_min[i], i))
    min_of_maxs = []
    for i in range(n):
        heapq.heappush(min_of_maxs, (cur_max[i], i))
    def get_L():
        while max_of_mins and -max_of_mins[0][0] != cur_min[max_of_mins[0][1]]:
            heapq.heappop(max_of_mins)
        if not max_of_mins: return -1e100
        return -max_of_mins[0][0]
    def get_R():
        while min_of_maxs and min_of_maxs[0][0] != cur_max[min_of_maxs[0][1]]:
            heapq.heappop(min_of_maxs)
        if not min_of_maxs: return 1e100
        return min_of_maxs[0][0]
    ok = False
    if get_L() <= get_R() + 1e-12:
        out_lines.append("Yes")
        continue
    m = len(events)
    idx = 0
    while idx < m:
        ang = events[idx][0]
        j = idx
        while j < m and abs(events[j][0] - ang) < 1e-15:
            j += 1
        test_ang = ang + 1e-10
        if test_ang >= math.pi: test_ang -= math.pi
        for k in range(idx, j):
            irect = events[k][1]
            mn, mx = proj_bounds_at(irect, test_ang)
            cur_min[irect] = mn
            cur_max[irect] = mx
            heapq.heappush(max_of_mins, (-mn, irect))
            heapq.heappush(min_of_maxs, (mx, irect))
        if get_L() <= get_R() + 1e-12:
            ok = True
            break
        idx = j
    out_lines.append("Yes" if ok else "No")
sys.stdout.write("\n".join(out_lines))
