import sys
import math

input = sys.stdin.readline

def rect_angles(x1, y1, x2, y2):
    return [
        (x1, y1),
        (x1, y2),
        (x2, y1),
        (x2, y2)
    ]

def angle_of(x, y):
    return math.atan2(y, x)

def critical_angles(rect):
    (x1, y1, x2, y2) = rect
    pts = rect_angles(x1, y1, x2, y2)
    ang = []
    for (x, y) in pts:
        ang.append(angle_of(x, y))
    ang.sort()
    res = []
    for i in range(4):
        a = ang[i]
        b = ang[(i+1) % 4]
        mid = (a + b) * 0.5
        if abs(a - b) > math.pi:
            mid += math.pi
        res.append(mid)
    return res

def proj_bounds(rect, ang):
    (x1, y1, x2, y2) = rect
    c = math.cos(ang)
    s = math.sin(ang)
    ps = [
        x1 * c + y1 * s,
        x1 * c + y2 * s,
        x2 * c + y1 * s,
        x2 * c + y2 * s
    ]
    return min(ps), max(ps)

def check(rects, ang):
    L = -1e50
    R = 1e50
    c = math.cos(ang)
    s = math.sin(ang)
    for (x1, y1, x2, y2) in rects:
        p1 = x1 * c + y1 * s
        p2 = x1 * c + y2 * s
        p3 = x2 * c + y1 * s
        p4 = x2 * c + y2 * s
        mn = min(p1, p2, p3, p4)
        mx = max(p1, p2, p3, p4)
        if mn > R or mx < L:
            return False
        L = max(L, mn)
        R = min(R, mx)
    return L <= R + 1e-12

T = int(input())
answers = []

for _ in range(T):
    n = int(input())
    rects = [tuple(map(int, input().split())) for _ in range(n)]

    cand = [0.0, math.pi * 0.5, math.pi, math.pi * 1.5]

    for rect in rects:
        for a in critical_angles(rect):
            a %= (2 * math.pi)
            cand.append(a)
            cand.append((a + 1e-7) % (2 * math.pi))
            cand.append((a - 1e-7) % (2 * math.pi))

    ok = False
    for a in cand:
        if check(rects, a):
            ok = True
            break

    answers.append("Yes" if ok else "No")

print("\n".join(answers))
