import sys

sys.setrecursionlimit(200000)


def solve():
    input_data = sys.stdin.read().split()
    if not input_data:
        return

    n_digits = int(input_data[0])
    K = int(input_data[1])
    R_str = input_data[2]
    R_int = int(R_str)

    MOD = 10 ** 9 + 7

    if R_int == 0:
        print(1 % MOD)
        return

    bits = [int(c) for c in bin(R_int)[2:]]
    bits.reverse()  # Теперь bits[0] - младший бит
    N = len(bits)

    HEX_CHARS = 24

    def poly_mul_packed(A, B):
        if not A or not B:
            return []

        if len(A) * len(B) < 1600:
            res = [0] * (len(A) + len(B) - 1)
            for i, x in enumerate(A):
                if x == 0: continue
                for j, y in enumerate(B):
                    if y == 0: continue
                    res[i + j] = (res[i + j] + x * y) % MOD
            return res

        sA = "".join([f"{x:024x}" for x in reversed(A)])
        iA = int(sA, 16)
        sB = "".join([f"{x:024x}" for x in reversed(B)])
        iB = int(sB, 16)

        iRes = iA * iB

        if iRes == 0:
            return []

        sRes = f"{iRes:x}"
        slen = len(sRes)
        num_chunks = (slen + HEX_CHARS - 1) // HEX_CHARS
        sRes = sRes.zfill(num_chunks * HEX_CHARS)

        res = []
        for i in range(num_chunks):
            end = len(sRes) - i * HEX_CHARS
            start = end - HEX_CHARS
            chunk = sRes[start:end]
            res.append(int(chunk, 16) % MOD)

        return res

    def poly_add(A, B):
        if len(A) < len(B):
            A, B = B, A
        if not B:
            return A[:]
        res = list(A)
        for i, x in enumerate(B):
            res[i] = (res[i] + x) % MOD
        return res

    def reduce_cyclic(poly):
        if len(poly) <= K:
            return poly
        res = poly[:K]
        for i in range(K, len(poly)):
            idx = i % K
            res[idx] = (res[idx] + poly[i]) % MOD
        return res

    def rotate_poly(poly, s):
        s %= K
        if s == 0 or not poly:
            return poly

        res = [0] * K
        for i, x in enumerate(poly):
            res[(i + s) % K] = (res[(i + s) % K] + x) % MOD
        return res

    def solve_rec(l, r):
        if l == r:
            bit = bits[l]
            ans = [1] if bit == 1 else []
            return ans, [1, 1], bit

        mid = (l + r) // 2

        L_ans, L_pow, L_pop = solve_rec(l, mid)
        R_ans, R_pow, R_pop = solve_rec(mid + 1, r)

        t1 = poly_mul_packed(R_ans, L_pow)
        t1 = reduce_cyclic(t1)

        t2 = rotate_poly(L_ans, R_pop)

        new_ans = poly_add(t1, t2)

        new_pow = poly_mul_packed(L_pow, R_pow)
        new_pow = reduce_cyclic(new_pow)

        return new_ans, new_pow, L_pop + R_pop

    ans_poly, _, _ = solve_rec(0, N - 1)

    res = ans_poly[0] if ans_poly else 0

    if sum(bits) % K == 0:
        res = (res + 1) % MOD

    print(res)


if __name__ == '__main__':
    solve()