import sys
MOD = 10**9 + 7

def dec_to_bits(s):
    a = list(map(int, s))
    bits = []
    while any(a):
        carry = 0
        new = []
        for d in a:
            cur = carry*10 + d
            q = cur // 2
            r = cur % 2
            if new or q:
                new.append(q)
            carry = r
        bits.append(carry)
        a = new
    if not bits:
        return [0]
    return bits[::-1]

MAX = 100000
fact = [1]*(MAX+1)
invfact = [1]*(MAX+1)
for i in range(1, MAX+1):
    fact[i] = fact[i-1]*i % MOD
invfact[MAX] = pow(fact[MAX], MOD-2, MOD)
for i in range(MAX, 0, -1):
    invfact[i-1] = invfact[i]*i % MOD

def C(n,k):
    if k<0 or k>n: return 0
    return fact[n]*invfact[k]%MOD*invfact[n-k]%MOD

def solve(Rdec, K):
    bits = dec_to_bits(Rdec)
    B = len(bits)
    used = 0
    ans = 0
    for i, bit in enumerate(bits):
        if bit == 1:
            rem = B - i - 1
            ans = (ans + C(rem, K-used)) % MOD
            used += 1
            if used > K:
                break
    if used == K:
        ans = (ans + 1) % MOD
    if 0 % K == 0:
        ans = (ans + 1) % MOD
    return ans % MOD

if __name__ == "__main__":
    data = sys.stdin.read().split()
    n = int(data[0])
    K = int(data[1])
    Rdec = data[2].lstrip("0")
    if Rdec == "": Rdec = "0"
    print(solve(Rdec, K))
