import sys

MOD = 10**9 + 7

def decstr_to_bits(s):
    a = [int(ch) for ch in s]
    bits = []
    while any(a):
        carry = 0
        new = []
        for d in a:
            cur = carry*10 + d
            q = cur // 2
            r = cur % 2
            if new or q != 0:
                new.append(q)
            carry = r
        bits.append(carry)
        a = new
    if not bits:
        bits = [0]
    bits.reverse()
    return bits

def prepare_factorials(n):
    fact = [1] * (n+1)
    ifact = [1] * (n+1)
    for i in range(1, n+1):
        fact[i] = fact[i-1] * i % MOD
    ifact[n] = pow(fact[n], MOD-2, MOD)
    for i in range(n, 0, -1):
        ifact[i-1] = ifact[i] * i % MOD
    return fact, ifact

def C(n, k, fact, ifact):
    if k < 0 or k > n or n < 0:
        return 0
    return fact[n] * ifact[k] % MOD * ifact[n-k] % MOD

def count_good(Rdec, K):
    bits = decstr_to_bits(Rdec)
    B = len(bits)
    if K == 1:
        rmod = 0
        for ch in Rdec:
            rmod = (rmod*10 + (ord(ch)-48)) % MOD
        return (rmod + 1) % MOD
    if K > B:
        return 1

    fact, ifact = prepare_factorials(B)

    ans = 0
    ones = 0
    for i, bit in enumerate(bits):
        rem = B - i - 1
        if bit == 1:
            target = (-ones) % K
            j = target
            while j <= rem:
                ans = (ans + C(rem, j, fact, ifact)) % MOD
                j += K
            ones += 1

    if ones % K == 0:
        ans = (ans + 1) % MOD

    return ans

if __name__ == "__main__":
    data = sys.stdin.read().strip().split()
    if not data:
        sys.exit(0)
    n = int(data[0])
    K = int(data[1])
    Rdec = data[2].lstrip('0')
    if Rdec == '':
        Rdec = '0'
    print(count_good(Rdec, K))
