def line_intersects_rext(x1, y1, x2, y2, rx1, ry1, rx2, ry2):
    min_x, max_x = min(rx1, rx2), max(rx1, rx2)
    min_y, max_y = min(ry1, ry2), max(ry1, ry2)

    if x1 == x2:
        return min_x <= x1 <= max_x
    if y1 == y2:
        return min_y <= y1 <= max_y

    dx = x2 - x1
    dy = y2 - y1

    def get_y(x):
        return y1 + dy * (x - x1) / dx

    def get_x(y):
        return x1 + dx * (y - y1) / dy

    for x in [min_x, max_x]:
        if min_y <= get_y(x) <= max_y:
            return True
    for y in [min_y, max_y]:
        if min_x <= get_x(y) <= max_x:
            return True

    corners = [(min_x, min_y), (min_x, max_y), (max_x, min_y), (max_x, max_y)]
    signs = []
    for cx, cy in corners:
        sign_val = (cy - y1) * dx - (cx - x1) * dy
        if abs(sign_val) < 1e-9:
            return True
        signs.append(sign_val > 0)
    return not all(signs) and any(signs)


def check_all_rects(x1, y1, x2, y2, rects):
    for rect in rects:
        if not line_intersects_rext(x1, y1, x2, y2, *rect):
            return False
    return True


def solve(n, rects):
    if n <= 1:
        return "Yes"

    max_left = max(min(r[0], r[2]) for r in rects)
    min_right = min(max(r[0], r[2]) for r in rects)
    if max_left <= min_right:
        return "Yes"

    max_bottom = max(min(r[1], r[3]) for r in rects)
    min_top = min(max(r[1], r[3]) for r in rects)
    if max_bottom <= min_top:
        return "Yes"

    pts = set()
    for x1, y1, x2, y2 in rects:
        pts.add((x1, y1))
        pts.add((x1, y2))
        pts.add((x2, y1))
        pts.add((x2, y2))
        pts.add(((x1 + x2) / 2, (y1 + y2) / 2))

    pts = list(pts)

    for i, v1 in enumerate(pts):
        for j, v2 in enumerate(pts):
            if i >= j:
                continue
            if check_all_rects(v1[0], v1[1], v2[0], v2[1], rects):
                return "Yes"
    return "No"


T = int(input())
for _ in range(T):
    n = int(input())
    rects = []
    for _ in range(n):
        coords = list(map(int, input().split()))
        rects.append(coords)
    print(solve(n, rects))
