def sieve_spf(n):
    spf = list(range(n + 1))
    for i in range(2, int(n**0.5) + 1):
        if spf[i] == i:
            for j in range(i*i, n+1, i):
                if spf[j] == j:
                    spf[j] = i
    return spf

def is_odd_power_number(x, spf):
    while x > 1:
        p = spf[x]
        cnt = 0
        while x % p == 0:
            x //= p
            cnt += 1
        if cnt % 2 == 0:
            return False
    return True

m = int(input())
l, r = map(int, input().split())

spf = sieve_spf(r)
is_odd_power = [False] * (r + 1)

for i in range(l, r + 1):
    if is_odd_power_number(i, spf):
        is_odd_power[i] = True

count = 0
for i in range(l, r + 1):
    if is_odd_power[i]:
        count += 1
        if count == m:
            start = i - m + 1
            print(' '.join(str(start + j) for j in range(m)))
            break
    else:
        count = 0
else:
    print(-1)