import sys

def xomak():
    tokens = []
    while len(tokens) < 3:
        try:
            line = input()
            if not line: 
                continue
            tokens.extend(line.split())
        except EOFError:
            break
            
    if len(tokens) < 3:
        return

    n = int(tokens[0])
    m = int(tokens[1])
    k = int(tokens[2])
    
    
    if n > m:
        n, m = m, n
        
    results = []
    
    def sum_arithmetic(count, first, last):
        return count * (first + last) // 2

    def get_sequence_params(start_range, end_range, k, target_rem):
        rem_start = start_range % k
        offset = (target_rem - rem_start + k) % k
        first_val = start_range + offset
        
        if first_val > end_range:
            return 0, 0, 0
            
        rem_end = end_range % k
        offset_end = (rem_end - target_rem + k) % k
        last_val = end_range - offset_end
        
        count = (last_val - first_val) // k + 1
        return count, first_val, last_val

    for c in range(1, k + 1):
        total_cells = 0
        

        target_rem = c % k
        
        if n > 1:
            cnt, first, last = get_sequence_params(1, n - 1, k, target_rem)
            if cnt > 0:
                total_cells += sum_arithmetic(cnt, first, last)
        
        cnt, _, _ = get_sequence_params(n, m, k, target_rem)
        if cnt > 0:
            total_cells += cnt * n
            
        if n + m - 1 >= m + 1:
            cnt, first, last = get_sequence_params(m + 1, n + m - 1, k, target_rem)
            if cnt > 0:
                sum_d = sum_arithmetic(cnt, first, last)
                total_cells += cnt * (n + m) - sum_d
        
        results.append(str(total_cells))
        
    print(" ".join(results))

if __name__ == "__main__":
    xomak()