import sys
import random


def line_touches_rect(x1, y1, x2, y2, a, b, c):

    vals = []
    for x in (x1, x2):
        for y in (y1, y2):
            vals.append(a * x + b * y + c)
    if all(v > 0 for v in vals) or all(v < 0 for v in vals):
        return False
    return True

def solve():
    import sys
    data = sys.stdin.read().split()
    if not data:
        return
    t = int(data[0])
    idx = 1
    out = []

    for _ in range(t):
        n = int(data[idx]);
        idx += 1
        rects = []
        points = []
        for __ in range(n):
            x1 = int(data[idx]);
            y1 = int(data[idx + 1])
            x2 = int(data[idx + 2]);
            y2 = int(data[idx + 3])
            idx += 4
            rects.append((x1, y1, x2, y2))
            points.append((x1, y1))
            points.append((x1, y2))
            points.append((x2, y1))
            points.append((x2, y2))

        x_left = max(r[0] for r in rects)
        x_right = min(r[2] for r in rects)
        if x_left <= x_right:
            out.append("Yes")
            continue

        y_bottom = max(r[1] for r in rects)
        y_top = min(r[3] for r in rects)
        if y_bottom <= y_top:
            out.append("Yes")
            continue

        found = False
        if len(points) > 200:
            sampled_points = random.sample(points, 200)
        else:
            sampled_points = points

        directions = [(1, 0), (0, 1), (-1, 0), (0, -1)]

        for i in range(len(sampled_points)):
            for j in range(i + 1, len(sampled_points)):
                x1, y1 = sampled_points[i]
                x2, y2 = sampled_points[j]
                if x1 == x2 and y1 == y2:
                    continue
                a = y2 - y1
                b = -(x2 - x1)
                c = x2 * y1 - x1 * y2
                ok = True
                for rect in rects:
                    if not line_touches_rect(*rect, a, b, c):
                        ok = False
                        break
                if ok:
                    found = True
                    break
            if found:
                break

        if not found:
            for dx, dy in directions:
                for px, py in sampled_points[:50]:
                    a = dy
                    b = -dx
                    c = dx * py - dy * px
                    ok = True
                    for rect in rects:
                        if not line_touches_rect(*rect, a, b, c):
                            ok = False
                            break
                    if ok:
                        found = True
                        break
                if found:
                    break

        out.append("Yes" if found else "No")

    sys.stdout.write("\n".join(out))

if __name__ == "__main__":
    solve()