def line_intersects_rect(x1, y1, x2, y2, a, b, c):
    vals = []
    for x in (x1, x2):
        for y in (y1, y2):
            vals.append(a * x + b * y + c)
    if all(v > 0 for v in vals) or all(v < 0 for v in vals):
        return False
    return True


def solve():
    import sys
    input = sys.stdin.read
    data = input().split()
    t = int(data[0])
    idx = 1
    out_lines = []
    for _ in range(t):
        n = int(data[idx]);
        idx += 1
        rects = []
        for __ in range(n):
            x1 = int(data[idx]);
            y1 = int(data[idx + 1])
            x2 = int(data[idx + 2]);
            y2 = int(data[idx + 3])
            idx += 4
            rects.append((x1, y1, x2, y2))

        x_left = max(r[0] for r in rects)
        x_right = min(r[2] for r in rects)
        if x_left <= x_right:
            out_lines.append("Yes")
            continue

        y_bottom = max(r[1] for r in rects)
        y_top = min(r[3] for r in rects)
        if y_bottom <= y_top:
            out_lines.append("Yes")
            continue

        found = False
        points = []
        for x1, y1, x2, y2 in rects:
            points.append((x1, y1))
            points.append((x1, y2))
            points.append((x2, y1))
            points.append((x2, y2))

        limit = min(200, len(points))
        for i in range(limit):
            for j in range(i + 1, limit):
                x1, y1 = points[i]
                x2, y2 = points[j]
                if x1 == x2 and y1 == y2:
                    continue
                a = y2 - y1
                b = -(x2 - x1)
                c = x2 * y1 - x1 * y2
                ok = True
                for rect in rects:
                    if not line_intersects_rect(*rect, a, b, c):
                        ok = False
                        break
                if ok:
                    found = True
                    break
            if found:
                break

        out_lines.append("Yes" if found else "No")
    sys.stdout.write("\n".join(out_lines))

if __name__ == "__main__":
    solve()