import sys
import math


def solve():
    input_data = sys.stdin.read().split()
    t = int(input_data[0])
    idx = 1
    out = []
    for _ in range(t):
        n = int(input_data[idx]);
        idx += 1
        rects = []
        for __ in range(n):
            x1 = int(input_data[idx]);
            y1 = int(input_data[idx + 1])
            x2 = int(input_data[idx + 2]);
            y2 = int(input_data[idx + 3])
            idx += 4
            rects.append((x1, y1, x2, y2))

        def check_vertical():
            x_left = max(r[0] for r in rects)
            x_right = min(r[2] for r in rects)
            return x_left <= x_right

        def check_horizontal():
            y_bottom = max(r[1] for r in rects)
            y_top = min(r[3] for r in rects)
            return y_bottom <= y_top

        if check_vertical() or check_horizontal():
            out.append("Yes")
            continue

        def line_intersects_all(theta):
            a = math.cos(theta)
            b = math.sin(theta)
            min_proj = float('inf')
            max_proj = -float('inf')
            for x1, y1, x2, y2 in rects:
                vals = [a * x1 + b * y1, a * x1 + b * y2, a * x2 + b * y1, a * x2 + b * y2]
                min_v = min(vals)
                max_v = max(vals)
                min_proj = min(min_proj, max_v)
                max_proj = max(max_proj, min_v)
            return max_proj <= min_proj

        found = False
        steps = 64
        for i in range(steps):
            theta = math.pi * i / steps
            if line_intersects_all(theta):
                found = True
                break

        out.append("Yes" if found else "No")
    sys.stdout.write("\n".join(out))


if __name__ == "__main__":
    solve()