import sys

MOD = 10**9 + 7

def dec_to_bin(s):
    bits = []
    nums = [int(ch) for ch in s]
    while nums:
        carry = 0
        new_nums = []
        for digit in nums:
            cur = carry * 10 + digit
            new_nums.append(cur // 2)
            carry = cur % 2
        bits.append(str(carry))
        while new_nums and new_nums[0] == 0:
            new_nums.pop(0)
        nums = new_nums
    bits.reverse()
    while len(bits) > 1 and bits[0] == '0':
        bits.pop(0)
    return ''.join(bits)

def solve():
    data = sys.stdin.read().split()
    if not data:
        return
    t = 0
    n = int(data[t]); t += 1
    K = int(data[t]); t += 1
    R_str = data[t]; t += 1

    bin_str = dec_to_bin(R_str)
    L = len(bin_str)

    if K > L:
        print(1)
        return

    dp_tight0 = [0] * K
    dp_tight1 = [0] * K
    dp_tight1[0] = 1

    for ch in bin_str:
        bit = int(ch)
        new_tight0 = [0] * K
        new_tight1 = [0] * K
        for mod in range(K):
            val0 = dp_tight0[mod]
            if val0:
                new_tight0[mod] = (new_tight0[mod] + val0) % MOD
                new_mod = (mod + 1) % K
                new_tight0[new_mod] = (new_tight0[new_mod] + val0) % MOD
            val1 = dp_tight1[mod]
            if val1:
                if bit == 0:
                    new_tight1[mod] = (new_tight1[mod] + val1) % MOD
                else:
                    new_tight0[mod] = (new_tight0[mod] + val1) % MOD
                    new_mod = (mod + 1) % K
                    new_tight1[new_mod] = (new_tight1[new_mod] + val1) % MOD
        dp_tight0, dp_tight1 = new_tight0, new_tight1

    ans = (dp_tight0[0] + dp_tight1[0]) % MOD
    print(ans)

if __name__ == "__main__":
    solve()