#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef long double ld;


vector<bool> primes(int n){
    vector<bool> prime(n + 1, 1);
    prime[0] = prime[1] = 0;
    for (int i = 2; i <= n; ++i) {
        if (prime[i]) {
            for (int j = i * 2; j < n; j += i) {
                prime[j] = 0;
            }
        }
    }
    return prime;
}
map<int, int> factorize(int n) {
    map<int, int> result;
    vector<bool> prime = primes(n);
    for (int i = 2; i <= n; ++i) {
        if (n % i == 0 && prime[i]) {
            result[i] = 0;
            while (n % i == 0) {
                result[i]++;
                n /= i;
            }
        }
        if (n == 1) break;
    }
    return result;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);
    int m, l, r;
    cin >> m >> l >> r;
    vector<int> result;
    vector<bool> E(r, 1);
    E[0] = E[1] = 0;
    for (int i = 1; i <= r; ++i) {
        if (E[i]) {
            bool fl = 1;
            map<int, int> prime_devs = factorize(i);
            for (auto j : prime_devs) {
                if (j.second % 2 == 0) {
                    fl = 0;
                    break;
                }
            }
            E[i] = fl;
            if (fl) {
                for (auto j : prime_devs) {
                    if (j.first * i <= r) {
                        E[j.first * i] = 0;
                    }
                }
            }
        }
        // cout << i << ' ' << E[i] << '\n';
    }
    int L = l, R = l;
    while (L <= r) {
        if (E[L]) {
            R++;
            if (R - L >= m) {
                break;
            }
            if (!E[R]) {
                L = R;
            }
        } else {
            L++;
            R++;
        }
        if (R > r) {
            break;
        }
    }
    if (R - L < m) {
        cout << -1;
        return 0;
    }
    for (int i = 0; i < m; ++i) {
        cout << L + i << ' ';
    }
}
