#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef long double ld;


vector<bool> primes(int n){
    vector<bool> prime(n + 1, 1);
    prime[0] = prime[1] = 0;
    for (int i = 2; i <= n; ++i) {
        if (prime[i]) {
            for (int j = i * 2; j < n; j += i) {
                prime[j] = 0;
            }
        }
    }
    return prime;
}
map<int, int> factorize(int n) {
    map<int, int> result;
    vector<bool> prime = primes(n);
    for (int i = 2; i <= n; ++i) {
        if (n % i == 0 && prime[i]) {
            result[i] = 0;
            while (n % i == 0) {
                result[i]++;
                n /= i;
            }
        }
        if (n == 1) break;
    }
    return result;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);
    int m, l, r;
    cin >> m >> l >> r;
    vector<int> result, pref(r - l + 1, 0);
    vector<bool> E(r - l + 1, 1);
    E[1] = 0;
    for (int i = l; i <= r; ++i) {
        if (E[i]) {
            bool fl = 1;
            map<int, int> prime_devs = factorize(i);
            for (auto j : prime_devs) {
                if (j.second % 2 == 0) {
                    fl = 0;
                    break;
                }
            }
            if (fl) {
                for (auto j : prime_devs) {
                    if (j.first * i < r) {
                        E[j.first * i] = 0;
                    }
                }
            } else {
                E[i] = 0;
            }
        }
    }
    for (int i = l; i < r; ++i) {
        pref[i] = pref[i - 1] + E[i];
    }
    int i = l, j = l + 1;
    while (i <= r) {
        if (pref[j] - pref[i] == m) {
            if (j - i == m) {
                break;
            }
            i++;
        } else {
            if (j == r) {
                break;
            }
            j++;
        }
    }
    if (j - i == m && pref[j] - pref[i] == m) {
        for (int x = i + 1; x <= j; ++x) {
            cout << x << ' ';
        }
        return 0;
    }
    cout << -1;
}
