#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef long double ld;


vector<bool> primes(int n){
    vector<bool> prime(n + 1, 1);
    prime[0] = prime[1] = 0;
    for (int i = 2; i <= n; ++i) {
        if (prime[i]) {
            for (int j = i * 2; j < n; j += i) {
                prime[j] = 0;
            }
        }
    }
    return prime;
}
map<int, int> factorize(int n) {
    map<int, int> result;
    vector<bool> prime = primes(n);
    for (int i = 2; i <= n; ++i) {
        if (n % i == 0 && prime[i]) {
            result[i] = 0;
            while (n % i == 0) {
                result[i]++;
                n /= i;
            }
        }
        if (n == 1) break;
    }
    return result;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);
    int m, l, r;
    cin >> m >> l >> r;
    vector<int> result;
    for (int i = l; i <= r; ++i) {
        bool fl = 1;
        map<int, int> prime_devs = factorize(i);
        for (auto i : prime_devs) {
            if (i.second % 2 == 0) {
                fl = 0;
                break;
            }
        }
        if (fl) {
            result.push_back(i);
        } else {
            result.resize(0);
        }
        if (result.size() >= m) {
            for (const int& j : result) {
                cout << j << ' ';
            }
            return 0;
        }
    }
    cout << -1;
}
