#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

bool is_odd_powerful(int n) {
    int original_n = n;
    for (int i = 2; i * i <= n; i++) {
        if (n % i == 0) {
            int count = 0;
            while (n % i == 0) {
                n /= i;
                count++;
            }
            if (count % 2 == 0) {
                return false;
            }
        }
    }
    return true;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int m;
    cin >> m;
    int l, r;
    cin >> l >> r;

    vector<bool> is_odd_pow(r + 1, false);
    for (int i = 1; i <= r; i++) {
        is_odd_pow[i] = is_odd_powerful(i);
    }

    for (int start = l; start <= r - m + 1; start++) {
        bool valid = true;
        for (int j = 0; j < m; j++) {
            if (!is_odd_pow[start + j]) {
                valid = false;
                break;
            }
        }
        if (valid) {
            for (int j = 0; j < m; j++) {
                cout << (j == 0 ? "" : " ") << start + j;
            }
            cout << endl;
            return 0;
        }
    }

    cout << -1 << endl;
    return 0;
}