#include <bits/stdc++.h>

using namespace std;

#define ld long double
#define ll long long
#define all(x) x.begin(), x.end()
#define sz(x) (int)x.size()
#define pb push_back
#define int long long

struct quad{
    int x1, y1, x2, y2;

    quad() {}

    quad(int a, int b, int c, int d) {
        x1 = a, y1 = b, x2 = c, y2 = d;
    }
};

const int C = 300;
const ld eps = 1e-1;

void solve() {
    int n;
    cin >> n;
    vector<quad> a(n);
    map<int, int> r, c;
    int l1 = -1e9, r1 = -1e9, l2 = 1e9, r2 = 1e9;
    vector<ld> m1(C, -1e18), m2(C, 1e18), m3(C, -1e18), m4(C, 1e18);
    for (int i = 0; i < n; ++i) {
        cin >> a[i].x1 >> a[i].y1 >> a[i].x2 >> a[i].y2;
        r[a[i].x1]++;
        r[a[i].x2]++;
        c[a[i].y1]++;
        c[a[i].y2]++;
        l1 = max(l1, a[i].x1);
        l2 = min(l2, a[i].x2);
        r1 = max(r1, a[i].y1);
        r2 = min(r2, a[i].y2);
        for (int j = 1; j < C; ++j) {
            ld tek = acos(-1) / 2 * j / C;
            ld cur = tan(tek);
            m1[j] = max(m1[j], (ld) a[i].x1 - a[i].y2 * cur);
            m2[j] = min(m2[j], (ld) a[i].x2 - a[i].y1 * cur);
            m3[j] = max(m3[j], (ld) a[i].x1 + a[i].y1 * cur);
            m4[j] = min(m4[j], (ld) a[i].x2 + a[i].y2 * cur);
        }
    }
    if (n <= 2) {
        cout << "Yes\n";
        return;
    }
    if (l1 <= l2 || r1 <= r2) {
        cout << "Yes\n";
        return;
    }
    for (int i = 1; i < C; ++i) {
        if (abs(m1[i] - m2[i]) <= eps || abs(m3[i] - m4[i]) <= eps) {
            cout << "Yes\n";
            return;
        }
    }
    cout << "No\n";
}

signed main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    int t;
    cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}