import sys
input = sys.stdin.readline

m = int(input())
l, r = map(int, input().split())

max_n = 10 ** 6 + 1
spf = list(range(max_n))

for i in range(2, max_n):
    if spf[i] == i:
        for j in range(i * i, max_n, i):
            if spf[j] == j:
                spf[j] = i

def is_odd_power(n):
    while n > 1:
        p = spf[n]
        count = 0
        while n % p == 0:
            count += 1
            n //= p
        if count % 2 == 0:
            return False
    return True

count = 0

for n in range(l, r + 1):
    if is_odd_power(n):
        count += 1
        if count == m:
            print(*range(n - m + 1, n + 1))
            exit()
    else:
        count = 0

print(-1)