import sys
input = sys.stdin.readline

n = int(input())
m = int(input())
k = int(input())

growth_start = 2
growth_end = min(n, m)

plato_start = min(n, m) + 1
plato_end = max(n, m) + 1

decay_start = max(n, m) + 2
decay_end = n + m

def find_first_in_phase(start, c):
    first_diagonal = c + 1
    if first_diagonal >= start:
        return first_diagonal
    steps = (start - first_diagonal + k - 1) // k
    return first_diagonal + steps * k

def count_in_phase(start, end, c):
    first_in_phase = find_first_in_phase(start, c)
    if first_in_phase > end:
        return 0, first_in_phase
    count = (end - first_in_phase) // k + 1
    return count, first_in_phase

def sum_growth(start, end, c):
    count, first = count_in_phase(start, end, c)
    if count == 0:
        return 0
    first_cells = first - 1
    last_cells = first - 1 + (count - 1) * k
    return (first_cells + last_cells) * count // 2

def sum_plato(start, end, c):
    count, first = count_in_phase(start, end, c)
    return count * min(n, m)

def sum_decay(start, end, c):
    count, first = count_in_phase(start, end, c)
    if count == 0:
        return 0
    first_cells = n + m - first + 1
    last_cells = n + m - (first + (count - 1) * k) + 1
    return (first_cells + last_cells) * count // 2

for c in range(1, k + 1):
    total = sum_growth(growth_start, growth_end, c) + sum_plato(plato_start, plato_end, c) + sum_decay(decay_start, decay_end, c)
    print(total)