#include <iostream>
#include <vector>
#include <algorithm>

#define ll long long

using namespace std;

const int MR = 1000000; 
int spf[MR + 1]; 
bool is_op[MR + 1]; 

void sieve() {
    for (int i = 0; i <= MR; ++i) {
        spf[i] = i;
    }

    for (int i = 2; i * i <= MR; ++i) {
        if (spf[i] == i) {
            for (int j = i * i; j <= MR; j += i) {
                if (spf[j] == j) {
                    spf[j] = i;
                }
            }
        }
    }

    is_op[1] = true; 
    for (int i = 2; i <= MR; ++i) {
        int p = spf[i]; 
        int c = 0;
        int t = i;  
        while (t % p == 0) { 
            c++;
            t /= p;
        }
        is_op[i] = (c % 2 != 0) && is_op[t];
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    sieve();

    ll m, l, r; 
    cin >> m >> l >> r;

    ll cc = 0;
    for (ll i = l; i <= r; ++i) {
        if (is_op[i]) {
            cc++;
        } else {
            cc = 0;
        }

        if (cc == m) {
            for (ll num = i - m + 1; num <= i; ++num) {
                cout << num << (num == i ? "" : " ");
            }
            cout << endl;
            return 0;
        }
    }

    cout << -1 << endl; 

    return 0;
}