#include<bits/stdc++.h>

using namespace std;

#define ld long double
#define ll long long
#define pb push_back
#define F first
#define S second
#define all(x) x.begin(), x.end()
#define sz(x) (int)x.size()
#define int long long

const int N = 2e5 + 100;
const int INF = 2e9 + 7;
int x[N], y[N], xx[N], yy[N];
const ld EPS = 1e-9;
int n;

ld getdist(ld x, ld y, ld xx, ld yy) {
    return sqrtl((x - xx) * (x - xx) + (y - yy) * (y - yy));
}

pair<ld, ld> getmin(ld a) {
    ld ax = cos(a);
    ld ay = sin(a);
    ld mn = INF;
    int j;
    for (int i = 0; i < n; ++i) {
        ld vect = ax * yy[i] - ay * x[i];
        if (vect < mn) {
            mn = vect;
            j = i;
        }
    }
    ld newx = x[j] + ay * mn;
    ld newy = yy[j] - ax * mn;
    return {mn, getdist(0, 0, newx, newy)};
}

pair<ld, ld> getmax(ld a) {
    ld ax = cos(a);
    ld ay = sin(a);
    ld mx = -INF;
    int j;
    for (int i = 0; i < n; ++i) {
        ld vect = ax * y[i] - ay * x[i];
        if (vect > mx) {
            mx = vect;
            j = i;
        }
    }
    ld newx = x[j] + ay * mx;
    ld newy = y[j] - ax * mx;
    return {mx, getdist(0, 0, newx, newy)};
}
pair<ld, ld> getmin2(ld a) {
    ld ax = cos(a);
    ld ay = sin(a);
    ld mn = INF;
    int j;
    for (int i = 0; i < n; ++i) {
        ld vect = ax * yy[i] - ay * xx[i];
        if (vect < mn) {
            mn = vect;
            j = i;
        }
    }
    ld newx = xx[j] + ay * mn;
    ld newy = yy[j] - ax * mn;
    return {mn, getdist(0, 0, newx, newy)};
}

pair<ld, ld> getmax2(ld a) {
    ld ax = cos(a);
    ld ay = sin(a);
    ld mx = -INF;
    int j;
    for (int i = 0; i < n; ++i) {
        ld vect = ax * y[i] - ay * xx[i];
        if (vect > mx) {
            mx = vect;
            j = i;
        }
    }
    ld newx = xx[j] + ay * mx;
    ld newy = y[j] - ax * mx;
    return {mx, getdist(0, 0, newx, newy)};
}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int t;
    cin >> t;
    while (t--) {
        cin >> n;
        int mnx = INF, mxx = 0;
        int mny = INF, mxy = 0;
        for (int i = 0; i < n; ++i) {
            cin >> x[i] >> y[i] >> xx[i] >> yy[i];
            mxx = max(x[i], mxx);
            mxy = max(y[i], mxy);
            mnx = min(xx[i], mnx);
            mny = min(yy[i], mny);
        }
        if (!(mnx < mxx && mny < mxy)) {
            cout << "Yes\n";
        } else {
            bool bl = false;
            ld l = 0;
            ld r = acos(-1) / (ld) 2;
            while (r - l > EPS) {
                ld m = (l + r) / (ld) 2;
                auto it = getmin(m);
                auto to = getmax(m);
                if (it.F >= to.F) {
                    bl = true;
                    break;
                }
                if (it.S >= to.S) {
                    r = m;
                } else {
                    l = m;
                }
            }
            if (bl) {
                cout << "Yes\n";
            } else {
                bl = false;
                r = 0;
                l = -acos(-1) / (ld) 2;
                while (r - l > EPS) {
                    ld m = (l + r) / (ld) 2;
                    auto it = getmin(m);
                    auto to = getmax(m);
                    if (it.F >= to.F) {
                        bl = true;
                        break;
                    }
                    if (it.S >= to.S) {
                        r = m;
                    } else {
                        l = m;
                    }
                }
                if (bl) {
                    cout << "Yes\n";
                } else {
                    cout << "No\n";
                }
            }
        }
    }
    return 0;
}