import sys
input = sys.stdin.readline

def check(norm_x, norm_y, rects):
    lo = -10**30
    hi =  10**30
    for x1, y1, x2, y2 in rects:
        # 4 угла
        p1 = x1*norm_x + y1*norm_y
        p2 = x1*norm_x + y2*norm_y
        p3 = x2*norm_x + y1*norm_y
        p4 = x2*norm_x + y2*norm_y
        L = min(p1,p2,p3,p4)
        R = max(p1,p2,p3,p4)
        if L > lo: lo = L
        if R < hi: hi = R
        if lo > hi:
            return False
    return True

T = int(input())
out = []
for _ in range(T):
    n = int(input())
    rects = [tuple(map(int,input().split())) for _ in range(n)]
    ok = (
        check(1,0,rects) or      # вертикальные прямые
        check(0,1,rects) or      # горизонтальные прямые
        check(1,1,rects) or      # угол 135°
        check(1,-1,rects)        # угол 45°
    )
    out.append("Yes" if ok else "No")

print("\n".join(out))
