
import sys
import math

def f(rects, k):
    ml = -1e300
    mu = 1e300
    if k >= 0:
        for x1,y1,x2,y2 in rects:
            low = y1 - k*x2
            up  = y2 - k*x1
            if low > ml: ml = low
            if up < mu:  mu = up
    else:
        for x1,y1,x2,y2 in rects:
            low = y1 - k*x1
            up  = y2 - k*x2
            if low > ml: ml = low
            if up < mu:  mu = up
    return ml - mu

data = sys.stdin.read().strip().split()
it = iter(data)
T = int(next(it))
out = []

for _ in range(T):
    n = int(next(it))
    rects = []
    xl = -1e300
    xr = 1e300
    for i in range(n):
        x1 = float(next(it)); y1 = float(next(it))
        x2 = float(next(it)); y2 = float(next(it))
        rects.append((x1,y1,x2,y2))
        if i == 0:
            xl = x1
            xr = x2
        else:
            if x1 > xl: xl = x1
            if x2 < xr: xr = x2

    if xl <= xr:
        out.append("Yes")
        continue

    if f(rects, 0.0) <= 0:
        out.append("Yes")
        continue

    L = -1e9 - 5
    R =  1e9 + 5
    best = f(rects, 0.0)

    for _ in range(90):
        m1 = L + (R-L)/3
        m2 = R - (R-L)/3
        f1 = f(rects, m1)
        f2 = f(rects, m2)
        if f1 < f2:
            R = m2
            if f1 < best: best = f1
        else:
            L = m1
            if f2 < best: best = f2

    if best <= 0:
        out.append("Yes")
    else:
        out.append("No")

print("\n".join(out))
