import sys

def can_cover(rects):
    n = len(rects)
    if n <= 2:
        return True
    
    lines = []
    for a in range(n):
        for b in range(a + 1, n):
            x1, y1, x2, y2 = rects[a]
            x3, y3, x4, y4 = rects[b]
            for (sx, sy) in [(x1, y1), (x1, y2), (x2, y1), (x2, y2)]:
                for (tx, ty) in [(x3, y3), (x3, y4), (x4, y3), (x4, y4)]:
                    if sx == tx and sy == ty:
                        continue
                    dx, dy = tx - sx, ty - sy
                    if dx == 0:
                        k = float('inf')
                        b = sx
                    elif dy == 0:
                        k = 0.0
                        b = sy
                    else:
                        k = dy / dx
                        b = sy - k * sx
                    lines.append((k, b))
    
    for k, b in lines:
        ok = True
        for i in range(n):
            x1, y1, x2, y2 = rects[i]
            touches = False
            if k == float('inf'):
                if x1 <= b <= x2:
                    touches = True
            else:
                for (px, py) in [(x1, y1), (x1, y2), (x2, y1), (x2, y2)]:
                    if abs(py - (k * px + b)) < 1e-9:
                        touches = True
                        break
                if not touches:
                    for edge in [(x1, y1, x2, y1), (x1, y2, x2, y2), (x1, y1, x1, y2), (x2, y1, x2, y2)]:
                        ex1, ey1, ex2, ey2 = edge
                        if ex1 == ex2:
                            if abs(ex1 - ((py - b) / k if k != 0 else float('inf'))) < 1e-9:
                                ymin, ymax = min(ey1, ey2), max(ey1, ey2)
                                if ymin <= py <= ymax:
                                    touches = True
                                    break
                        else:
                            if abs(ey1 - (k * ex1 + b)) < 1e-9:
                                xmin, xmax = min(ex1, ex2), max(ex1, ex2)
                                if xmin <= ex1 <= xmax:
                                    touches = True
                                    break
            if not touches:
                ok = False
                break
        if ok:
            return True
    return False

def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    t = int(data[0])
    idx = 1
    out_lines = []
    for _ in range(t):
        n = int(data[idx]); idx += 1
        rects = []
        for __ in range(n):
            x1 = int(data[idx]); y1 = int(data[idx+1])
            x2 = int(data[idx+2]); y2 = int(data[idx+3])
            idx += 4
            rects.append((x1, y1, x2, y2))
        if can_cover(rects):
            out_lines.append("Yes")
        else:
            out_lines.append("No")
    sys.stdout.write("\n".join(out_lines))

if __name__ == "__main__":
    solve()
