import sys
sys.setrecursionlimit(10**7)
MOD = 10**9+7

n, K = map(int, sys.stdin.readline().split())
R = sys.stdin.readline().strip()

# Вычисление количества чисел с заданным количеством бит и popcount ≡0 mod K.
# Максимальная длина бит у R:
maxL = len(bin(int(R)))-2

# Предвычисление биномиальных коэффициентов C[n][k] mod MOD
C = [[0]*(K) for _ in range(maxL+1)]
for i in range(maxL+1):
    C[i][0] = 1
    for j in range(1, min(i, K)):
        C[i][j] = (C[i-1][j] + C[i-1][j-1]) % MOD

def count_full(L):
    # количество чисел c L битами с popcount ≡ 0 mod K
    # popcount = c, ведущий бит = 1 => выбираем c-1 из L-1
    s = 0
    for c in range(1, min(L, K)):
        if c % K == 0:
            s = (s + C[L-1][c-1]) % MOD
    return s

# Счётчик чисел <= R с popcount ≡ 0 (mod K)
def solve_up_to(Rs):
    x = int(Rs)
    if x == 0:
        return 1 if (0 % K == 0) else 0
    bits = bin(x)[2:]
    L = len(bits)

    # 1) Все длины < L
    ans = 0
    for l in range(1, L):
        ans = (ans + count_full(l)) % MOD

    # 2) Текущая длина L — двоичное ДП
    pop = 0
    for i, b in enumerate(bits):
        if b == '1':
            rem = L - i - 1
            # Мы ставим 0 здесь, затем дальше любые rem бит
            # popcount добавляется = previous pop + popcount(any rem bits)
            for c in range(0, min(rem+1, K)):
                total = pop + c
                if total % K == 0:
                    ans = (ans + C[rem][c]) % MOD
        pop += (b == '1')

    if pop % K == 0:
        ans = (ans + 1) % MOD

    return ans

print(solve_up_to(R))
