def solve():
    import sys
    input = sys.stdin.readline
    
    m = int(input().strip())
    l, r = map(int, input().split())
    
    n = r

    lp = [0] * (n + 1)
    primes = []
    for i in range(2, n + 1):
        if lp[i] == 0:
            lp[i] = i
            primes.append(i)
        for p in primes:
            if p > lp[i] or i * p > n:
                break
            lp[i * p] = p

    def is_odd_power_num(x):
        while x > 1:
            p = lp[x]
            cnt = 0
            while x % p == 0:
                x //= p
                cnt += 1
            if cnt % 2 == 0:
                return False
        return True
    
    is_odd = [False] * (n + 1)
    for i in range(1, n + 1):
        if is_odd_power_num(i):
            is_odd[i] = True
    
    count = 0
    for i in range(l, r + 1):
        if is_odd[i]:
            count += 1
        else:
            count = 0
        
        if count >= m:
            start = i - m + 1
            print(" ".join(str(x) for x in range(start, start + m)))
            return
    
    print(-1)

if __name__ == "__main__":
    solve()
