def count_magic(N):
    if N < 7:
        return 0
    div7 = N // 7
    ends7 = (N - 7) // 10 + 1
    both = (N - 7) // 70 + 1
    return div7 + ends7 - both

def kth_magic_number(k):
    if k == 0:
        return 0
    lo, hi = 0, 10**18  
    while lo < hi:
        mid = (lo + hi) // 2
        if count_magic(mid) >= k:
            hi = mid
        else:
            lo = mid + 1
    return lo

if __name__ == "__main__":
    k = int(input())
    print(kth_magic_number(k))
