import sys
def solve():
    data = sys.stdin.read().strip().split()
    t = int(data[0])
    idx = 1
    results = []

    for _ in range(t):
        n = int(data[idx])
        idx += 1

        rects = []
        min_x_right = float('inf')
        max_x_left = -float('inf')
        min_y_top = float('inf')
        max_y_bottom = -float('inf')

        for i in range(n):
            x1 = int(data[idx]);
            y1 = int(data[idx + 1])
            x2 = int(data[idx + 2]);
            y2 = int(data[idx + 3])
            idx += 4
            rects.append((x1, y1, x2, y2))

            min_x_right = min(min_x_right, x2)
            max_x_left = max(max_x_left, x1)
            min_y_top = min(min_y_top, y2)
            max_y_bottom = max(max_y_bottom, y1)

        if min_y_top >= max_y_bottom or min_x_right >= max_x_left:
            results.append("Yes")
            continue

        corners = []
        for x1, y1, x2, y2 in rects:
            corners.append((x1, y1))
            corners.append((x1, y2))
            corners.append((x2, y1))
            corners.append((x2, y2))

        found = False
        for i in range(len(corners)):
            x1, y1 = corners[i]
            for j in range(i + 1, len(corners)):
                x2, y2 = corners[j]

                if x1 == x2 and y1 == y2:
                    continue

                rect_i = i // 4
                rect_j = j // 4
                if rect_i == rect_j:
                    continue
                if x1 == x2:
                    valid = True
                    for xa, ya, xb, yb in rects:
                        if not (xa <= x1 <= xb):
                            valid = False
                            break
                    if valid:
                        found = True
                        break
                    continue

                if y1 == y2:
                    valid = True
                    for xa, ya, xb, yb in rects:
                        if not (ya <= y1 <= yb):
                            valid = False
                            break
                    if valid:
                        found = True
                        break
                    continue

                k = (y2 - y1) / (x2 - x1)
                b = y1 - k * x1

                valid = True
                for xa, ya, xb, yb in rects:
                    corners_rect = [(xa, ya), (xa, yb), (xb, ya), (xb, yb)]
                    values = [k * x + b for x, y in corners_rect]

                    min_val = min(values)
                    max_val = max(values)

                    intersect = False

                    y_at_xa = k * xa + b
                    if ya <= y_at_xa <= yb:
                        intersect = True

                    y_at_xb = k * xb + b
                    if ya <= y_at_xb <= yb:
                        intersect = True

                    if k != 0:
                        x_at_ya = (ya - b) / k
                        if xa <= x_at_ya <= xb:
                            intersect = True

                        x_at_yb = (yb - b) / k
                        if xa <= x_at_yb <= xb:
                            intersect = True

                    if not intersect:
                        valid = False
                        break

                if valid:
                    found = True
                    break
            if found:
                break

        results.append("Yes" if found else "No")

    sys.stdout.write("\n".join(results))

solve()
