def main():
    # Чтение входных данных
    import sys
    data = sys.stdin.read().strip().split()

    if not data:
        return

    n = int(data[0])
    K = int(data[1])
    R_str = data[2]

    MOD = 10 ** 9 + 7

    # 1. Быстрое преобразование десятичного в двоичное
    digits = [int(ch) for ch in R_str]
    binary_digits = []

    # Конвертируем в двоичное через деление на 2
    while digits:
        remainder = 0
        new_digits = []
        for digit in digits:
            current = remainder * 10 + digit
            new_digits.append(current // 2)
            remainder = current % 2

        binary_digits.append(remainder)

        # Удаляем ведущие нули
        start = 0
        while start < len(new_digits) and new_digits[start] == 0:
            start += 1
        digits = new_digits[start:]

    binary_digits.reverse()  # старший бит теперь первый
    L = len(binary_digits)

    # 2. Если K=1, все числа подходят: R+1 чисел
    if K == 1:
        # Вычисляем R+1 по модулю MOD
        # Но R огромное, нужно вычислить (R+1) % MOD
        result = 0
        for digit in R_str:
            result = (result * 10 + int(digit)) % MOD
        result = (result + 1) % MOD
        print(result)
        return

    # 3. Оптимизированное ДП
    # Храним только два массива для tight=0 и tight=1
    dp_tight0 = [0] * K
    dp_tight1 = [0] * K
    dp_tight1[0] = 1

    for bit in binary_digits:
        new_tight0 = [0] * K
        new_tight1 = [0] * K

        # Предвычисляем переходы для всех возможных остатков
        # Для tight=0: можно поставить 0 или 1
        if sum(dp_tight0) > 0:  # есть активные состояния
            total_tight0 = sum(dp_tight0) % MOD
            # Для бита 0 остаток не меняется
            for mod in range(K):
                if dp_tight0[mod]:
                    new_tight0[mod] = (new_tight0[mod] + dp_tight0[mod]) % MOD

            # Для бита 1: остаток увеличивается на 1
            for mod in range(K):
                if dp_tight0[mod]:
                    new_mod = (mod + 1) % K
                    new_tight0[new_mod] = (new_tight0[new_mod] + dp_tight0[mod]) % MOD

        # Для tight=1: ограничены текущим битом R
        for mod in range(K):
            val = dp_tight1[mod]
            if val == 0:
                continue

            # Можно поставить 0
            if bit == 0:
                # Остаемся в tight=1, остаток не меняется
                new_tight1[mod] = (new_tight1[mod] + val) % MOD
            else:  # bit == 1
                # При 0 переходим в tight=0
                new_tight0[mod] = (new_tight0[mod] + val) % MOD

            # Можно поставить 1, только если bit == 1
            if bit == 1:
                new_mod = (mod + 1) % K
                new_tight1[new_mod] = (new_tight1[new_mod] + val) % MOD

        dp_tight0 = new_tight0
        dp_tight1 = new_tight1

    # Ответ
    answer = (dp_tight0[0] + dp_tight1[0]) % MOD
    print(answer)


    main()