//created int таджикистан
#include <iostream>
#include <cmath>
#include <deque>
#include <set>
#include <stack>
#include <queue>
#include <map>
#include <unordered_set>
#include <unordered_map>
#include <algorithm>
#include <random>
#include <fstream>
#include <bitset>
#include <chrono>
#include <iomanip>
#include <list>
#include <climits>
#include <cctype>
#include <cstring>
#include <ctime>

using namespace std;
using ll = long long;
using ld = long double;
//mt19937 rnd(chrono::steady_clock::now().time_since_epoch().count());
const int MAX = 200000;
const ll MOD = 1e9 + 7;
ll k_pow[MAX];
ll k1_pow[MAX];

ll fast_pow(ll a, ll b) {
    if (b == 0) {
        return 1ll;
    }
    if (b == 1) {
        return a;
    }
    if (b % 2 == 0) {
        ll num = fast_pow(a, b / 2);
        return num * num % MOD;
    } else {
        ll num = fast_pow(a, b / 2);
        num = num * num % MOD;
        return num * a % MOD;
    }
}

ll C(int n, int k) {
    if (k > n) {
        return 0ll;
    }
    ll cur = k1_pow[k] * k1_pow[n - k] % MOD;
    return k_pow[n] * cur % MOD;
}

int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    k_pow[0] = 1;
    k1_pow[0] = fast_pow(k_pow[0], MOD - 2);
    for (int i = 1; i < MAX; i++) {
        k_pow[i] = k_pow[i - 1] * i * 1ll;
        k_pow[i] %= MOD;
        k1_pow[i] = fast_pow(k_pow[i], MOD - 2);
    }
    int n, k;
    cin >> n >> k;
    ll num;
    cin >> num;
    vector<int> bit;
    while (num > 0) {
        if (num % 2 == 1) {
            bit.push_back(1);
        } else {
            bit.push_back(0);
        }
        num /= 2ll;
    }
    reverse(bit.begin(), bit.end());
    vector<vector<ll> > dp(bit.size() + 1, vector<ll>(k));
    for (int i = 1; i <= bit.size(); i++) {
        for (int j = 0; j <= i; j++) {
            dp[i][j % k] += C(i, j);
            dp[i][j % k] %= MOD;
        }
    }
    ll res = 0;
    int cnt = 0;
    for (int i = 0; i < (int) bit.size(); i++) {
        if (bit[i] == 0) {
            continue;
        }
        res += dp[(int) bit.size() - 1 - i][(k - cnt) % k];
        res %= MOD;
        cnt++;
        cnt %= k;
    }
    if (cnt == 0 && !bit.empty()) {
        res++;
    }
    cout << (res + 1) % MOD;
    return 0;
}
