import sys

def readints():
    return list(map(int, sys.stdin.readline().split()))

def line_from_points(p1, p2):

    x1, y1 = p1
    x2, y2 = p2
    A = y2 - y1
    B = x1 - x2
    C = x2*y1 - x1*y2
    return (A, B, C)

def point_on_line(p, line):

    x, y = p
    A, B, C = line
    return A*x + B*y + C == 0

def segment_intersects_line(seg, line):

    p1, p2 = seg
    val1 = line[0]*p1[0] + line[1]*p1[1] + line[2]
    val2 = line[0]*p2[0] + line[1]*p2[1] + line[2]
    if val1 == 0 or val2 == 0:
        return True 
    return (val1 > 0) != (val2 > 0) 

def rect_touches_line(rect, line):

    x1, y1, x2, y2 = rect

    corners = [(x1, y1), (x1, y2), (x2, y1), (x2, y2)]

    sides = [
        ((x1, y1), (x1, y2)),
        ((x1, y2), (x2, y2)),
        ((x2, y2), (x2, y1)),
        ((x2, y1), (x1, y1))
    ]

    for p in corners:
        if point_on_line(p, line):
            return True

    for seg in sides:
        if segment_intersects_line(seg, line):
            return True
    return False

def solve_case(n, rects):
    if n <= 2:
        return "YES"

    points = []
    for rect in rects[:3]:
        x1, y1, x2, y2 = rect
        points.append((x1, y1))
        points.append((x1, y2))
        points.append((x2, y1))
        points.append((x2, y2))

    for i in range(len(points)):
        for j in range(i+1, len(points)):
            p1 = points[i]
            p2 = points[j]
            if p1 == p2:
                continue
            line = line_from_points(p1, p2)
            # Проверяем, касается ли эта прямая всех прямоугольников
            if all(rect_touches_line(rect, line) for rect in rects):
                return "YES"
    return "NO"


T = int(input())
for _ in range(T):
    n = int(input())
    rects = []
    for _ in range(n):
        x1, y1, x2, y2 = readints()
        rects.append((x1, y1, x2, y2))
    result = solve_case(n, rects)
    print(result)

