MOD = 10**9 + 7

def decimal_str_to_binary(s):
    if s == "0":
        return "0"
    bits = []
    num = list(map(int, s))
    while num:
        rem = 0
        new_num = []
        for digit in num:
            rem = rem * 10 + digit
            new_num.append(rem // 2)
            rem %= 2
        bits.append(str(rem))
        # Убираем ведущие нули в new_num
        num = [d for d in new_num if d != 0] or [0]
        if num == [0]:
            break
    return ''.join(reversed(bits))

def solve():
    n, K = map(int, input().split())
    R_dec = input().strip()
    
    # Шаг 1: переводим R в двоичную запись
    R_bin = decimal_str_to_binary(R_dec)
    L = len(R_bin)
    
    from functools import lru_cache
    
    @lru_cache(maxsize=None)
    def dp(pos, cnt_mod, tight):
        if pos == L:
            return 1 if cnt_mod == 0 else 0
        
        res = 0
        max_bit = int(R_bin[pos]) if tight else 1
        
        for bit in range(0, max_bit + 1):
            new_tight = tight and (bit == max_bit)
            new_cnt_mod = (cnt_mod + bit) % K
            res = (res + dp(pos + 1, new_cnt_mod, new_tight)) % MOD
        
        return res
    
    result = dp(0, 0, True)
    print(result)

solve()
