MOD = 10**9 + 7


def solve():
    n, K = map(int, input().split())
    R = input().strip()
    
    # Предвычисляем popcount для цифр 0..9
    popcount_digit = [0, 1, 1, 2, 1, 2, 2, 3, 1, 2]
    
    from functools import lru_cache
    
    @lru_cache(maxsize=None)
    def dp(pos, cnt, tight, started):
        if pos == n:
            # Если число не начато (всё нули), то popcount=0
            if not started:
                return 1 if 0 % K == 0 else 0
            # Иначе проверяем, что cnt % K == 0
            return 1 if cnt % K == 0 else 0
        
        res = 0
        max_digit = int(R[pos]) if tight else 9
        
        for d in range(0, max_digit + 1):
            new_tight = tight and (d == max_digit)
            new_started = started or (d > 0)
            
            # Добавляем popcount текущей цифры
            add = popcount_digit[d] if new_started else 0
            new_cnt = (cnt + add) % K
            
            res = (res + dp(pos + 1, new_cnt, new_tight, new_started)) % MOD
        
        return res
    
    result = dp(0, 0, True, False)
    print(result)

solve()
