n = int(input())
m = int(input())
k = int(input())

# Массив для подсчёта клеток каждого цвета (1..k)
count = [0] * k

min_nm = min(n, m)
max_nm = max(n, m)
total_diagonals = n + m - 1

def add_group(start_d, end_d, length):
    if start_d > end_d:
        return
    # Номера диагоналей в группе: start_d, start_d+1, ..., end_d
    # Цвет диагонали d: (d - 1) % k
    first_color = (start_d - 1) % k
    last_color = (end_d - 1) % k
    num_diagonals = end_d - start_d + 1
    
    # Распределяем диагонали по цветам
    for c in range(k):
        # Сколько диагоналей цвета c в этом диапазоне?
        if first_color <= last_color:
            if c < first_color or c > last_color:
                cnt = 0
            else:
                cnt = (last_color - c) // k + 1 if c >= first_color else 0
        else:
            # Цикл через 0
            if c >= first_color or c <= last_color:
                if c >= first_color:
                    cnt = (k - 1 - c) // k + 1
                else:
                    cnt = (last_color - c) // k + 1
            else:
                cnt = 0
        
        # Более простой способ: используем арифметику
        cnt = 0
        d = start_d
        while d <= end_d:
            if (d - 1) % k == c:
                cnt += 1
                d += k
            else:
                d += 1
        
        count[c] += cnt * length

# Группа 1: d = 1 ... min(n,m), длина = d
start = 1
end = min_nm
for d in range(start, end + 1):
    color = (d - 1) % k
    count[color] += d

# Группа 2: d = min(n,m)+1 ... max(n,m), длина = min(n,m)
start = min_nm + 1
end = max_nm
if start <= end:
    length = min_nm
    for d in range(start, end + 1):
        color = (d - 1) % k
        count[color] += length

# Группа 3: d = max(n,m)+1 ... n+m-1, длина = n+m-d
start = max_nm + 1
end = total_diagonals
if start <= end:
    for d in range(start, end + 1):
        length = n + m - d
        color = (d - 1) % k
        count[color] += length

# Вывод результатов
for c in range(k):
    print(count[c])
