import sys
def intersects(rect, line_a, line_b, line_c):
    x1, y1, x2, y2 = rect
    corners = [(x1, y1), (x1, y2), (x2, y1), (x2, y2)]
    values =[line_a * x + line_b * y + line_c for (x, y) in corners]
    min_v = min(values)
    max_v = max(values)
    return min_v <= 0 <= max_v
def line_from_two_points(x1, y1, x2, y2):
    a = y2 - y1
    b = x1 - x2
    c= x2 * y1 - x1 * y2
    return a, b, c
def solve_one(n, rects):
    if n == 1:
        return True
    x_min = max(r[0] for r in rects)
    x_max = min(r[2] for r in rects)
    if x_min <= x_max:
        return True
    corners = []
    for idx,(x1, y1, x2, y2) in enumerate(rects):
        corners.append((x1, y1, idx))
        corners.append((x1, y2, idx))
        corners.append((x2, y1, idx))
        corners.append((x2, y2, idx))
    for i in range(len(corners)):
        xi, yi, idi = corners[i]
        for j in range(i + 1, len(corners)):
            xj, yj, idj = corners[j]
            if idi == idj:
                continue
            if xi == xj and yi == yj:
                continue
            a, b, c = line_from_two_points(xi, yi, xj, yj)
            ok = True
            for r in rects:
                if not intersects(r, a, b, c):
                    ok = False
                    break
            if ok:
                return True
    return False
def main():
    input_data = sys.stdin.read().strip().split()
    t = int(input_data[0])
    idx = 1
    results = []
    for _ in range(t):
        n = int(input_data[idx]); idx +=1
        rects = []
        for __ in range(n):
            x1 = int(input_data[idx]); y1 = int(input_data[idx+1])
            x2 = int(input_data[idx+2]); y2 = int(input_data[idx+3])
            idx += 4
            rects.append((x1, y1, x2, y2))
        res = solve_one(n, rects)
        results.append('Yes' if res else 'No')
    print('\n'.join(results))
if __name__=="__main__":
    main()
            














        









                
