python
import sys
import math

EPS = 1e-12
INF = 1e18


def solve_test_case():
    n = int(sys.stdin.readline().strip())

    rectangles = []
    for _ in range(n):
        x1, y1, x2, y2 = map(int, sys.stdin.readline().split())
        rectangles.append((x1, y1, x2, y2))

    y_min = -INF
    y_max = INF
    x_min = -INF
    x_max = INF

    for x1, y1, x2, y2 in rectangles:
        y_min = max(y_min, y1)
        y_max = min(y_max, y2)
        x_min = max(x_min, x1)
        x_max = min(x_max, x2)

    if y_min <= y_max or x_min <= x_max:
        return "Yes"

    if n <= 1:
        return "Yes"

    min_val1 = INF
    max_val1 = -INF
    min_val2 = INF
    max_val2 = -INF
    min_val3 = INF
    max_val3 = -INF
    min_val4 = INF
    max_val4 = -INF

    for x1, y1, x2, y2 in rectangles:
        min_val1 = min(min_val1, y2)
        max_val1 = max(max_val1, y1)

        min_val2 = min(min_val2, x2)
        max_val2 = max(max_val2, x1)

        corners = [(x1, y1), (x1, y2), (x2, y1), (x2, y2)]
        for cx, cy in corners:
            val = cx - cy
            min_val3 = min(min_val3, val)
            max_val3 = max(max_val3, val)

            val = cx + cy
            min_val4 = min(min_val4, val)
            max_val4 = max(max_val4, val)

    if max_val1 <= min_val1:
        return "Yes"
    elif max_val2 <= min_val2:
        return "Yes"
    elif max_val3 <= min_val3:
        return "Yes"
    elif max_val4 <= min_val4:
        return "Yes"

    vertices = []
    for x1, y1, x2, y2 in rectangles:
        vertices.append((x1, y1))
        vertices.append((x1, y2))
        vertices.append((x2, y1))
        vertices.append((x2, y2))

    found_any = False
    for i in range(min(len(vertices), 50)):
        for j in range(i + 1, min(len(vertices), 50)):
            x1, y1 = vertices[i]
            x2, y2 = vertices[j]

            if abs(x1 - x2) < EPS and abs(y1 - y2) < EPS:
                continue

            dx = x2 - x1
            dy = y2 - y1

            ok = True
            for rect in rectangles:
                rx1, ry1, rx2, ry2 = rect

                signs = []
                for cx, cy in [(rx1, ry1), (rx1, ry2), (rx2, ry1), (rx2, ry2)]:
                    cross = dx * (cy - y1) - dy * (cx - x1)
                    if abs(cross) < EPS:
                        signs.append(0)
                    elif cross > 0:
                        signs.append(1)
                    else:
                        signs.append(-1)

                if all(s == 1 for s in signs) or all(s == -1 for s in signs):
                    ok = False
                    break

            if ok:
                found_any = True
                break
        if found_any:
            break

    return "Yes" if found_any else "No"


def main():
    input_data = sys.stdin.read().strip().split()
    if not input_data:
        return

    idx = 0
    T = int(input_data[idx])
    idx += 1

    results = []
    for _ in range(T):
        n = int(input_data[idx])
        idx += 1

        rectangles = []
        for __ in range(n):
            x1 = int(input_data[idx]);
            idx += 1
            y1 = int(input_data[idx]);
            idx += 1
            x2 = int(input_data[idx]);
            idx += 1
            y2 = int(input_data[idx]);
            idx += 1
            rectangles.append((x1, y1, x2, y2))

        y_min = -INF
        y_max = INF
        x_min = -INF
        x_max = INF

        for x1, y1, x2, y2 in rectangles:
            y_min = max(y_min, y1)
            y_max = min(y_max, y2)
            x_min = max(x_min, x1)
            x_max = min(x_max, x2)

        if y_min <= y_max or x_min <= x_max:
            results.append("Yes")
            continue

        if n <= 1:
            results.append("Yes")
            continue

        min_val1 = INF
        max_val1 = -INF
        min_val2 = INF
        max_val2 = -INF
        min_val3 = INF
        max_val3 = -INF
        min_val4 = INF
        max_val4 = -INF

        for x1, y1, x2, y2 in rectangles:
            min_val1 = min(min_val1, y2)
            max_val1 = max(max_val1, y1)

            min_val2 = min(min_val2, x2)
            max_val2 = max(max_val2, x1)

            corners = [(x1, y1), (x1, y2), (x2, y1), (x2, y2)]
            for cx, cy in corners:
                val = cx - cy
                min_val3 = min(min_val3, val)
                max_val3 = max(max_val3, val)

                val = cx + cy
                min_val4 = min(min_val4, val)
                max_val4 = max(max_val4, val)

        if max_val1 <= min_val1:
            results.append("Yes")
        elif max_val2 <= min_val2:
            results.append("Yes")
        elif max_val3 <= min_val3:
            results.append("Yes")
        elif max_val4 <= min_val4:
            results.append("Yes")
        else:
            vertices = []
            for x1, y1, x2, y2 in rectangles:
                vertices.append((x1, y1))
                vertices.append((x1, y2))
                vertices.append((x2, y1))
                vertices.append((x2, y2))

            found_any = False
            for i in range(min(len(vertices), 50)):
                for j in range(i + 1, min(len(vertices), 50)):
                    x1, y1 = vertices[i]
                    x2, y2 = vertices[j]

                    if abs(x1 - x2) < EPS and abs(y1 - y2) < EPS:
                        continue

                    dx = x2 - x1
                    dy = y2 - y1

                    ok = True
                    for rect in rectangles:
                        rx1, ry1, rx2, ry2 = rect

                        signs = []
                        for cx, cy in [(rx1, ry1), (rx1, ry2), (rx2, ry1), (rx2, ry2)]:
                            cross = dx * (cy - y1) - dy * (cx - x1)
                            if abs(cross) < EPS:
                                signs.append(0)
                            elif cross > 0:
                                signs.append(1)
                            else:
                                signs.append(-1)

                        if all(s == 1 for s in signs) or all(s == -1 for s in signs):
                            ok = False
                            break

                    if ok:
                        found_any = True
                        break
                if found_any:
                    break

            results.append("Yes" if found_any else "No")

    sys.stdout.write("\n".join(results))


if __name__ == "__main__":
    main()
