#include<bits/stdc++.h>

using namespace std;
using ld = long double;
using ll = long long;
using ull = unsigned long long;

const ll MOD = 1e9 + 7;
const ll INF = 1e18, NINF = -1e18;

bool check1(vector<tuple<ll, ll, ll, ll>> &points) {
    ll bot = 0, top = INF;
    ll left = 0, right = INF;

    for (auto &[x1, y1, x2, y2] : points) {
        left = max(left, x1);
        right = min(right, x2);

        top = min(top, y2);
        bot = max(bot, y1);
    }

    if (bot > top && left > right) {
        return false;
    } else {
        return true;
    }
}

bool check2(vector<tuple<ll, ll, ll, ll>> &points) {
    ll mn1 = NINF, mx1 = INF;
    ll mn2 = NINF, mx2 = INF;

    for (auto &[x1, y1, x2, y2] : points) {
        mn1 = max(mn1, y1 - x2);
        mx1 = min(mx1, y2 - x1);

        mn2 = max(mn2, y1 + x1);
        mx2 = min(mx2, y2 + x2);
    }

    if (mn1 > mx1 && mn2 > mx2) {
        return false;
    } else {
        return true;
    }
}

int main() {
    ll t;

    cin >> t;

    while (t--) {
        ll n;
        cin >> n;

        vector<tuple<ll, ll, ll, ll>> points(n);

        for (int i = 0; i < n; i++) {
            ll x1, y1, x2, y2;
            cin >> x1 >> y1 >> x2 >> y2;

            points[i] = {x1, y1, x2, y2};
        }

        if (n <= 2) {
            cout << "Yes\n";
        } else if (check1(points)) {
            cout << "Yes\n";
        } else if (check2(points)) {
            cout << "Yes\n";
        } else {
            cout << "No\n";
        }
    }

    return 0;
}
