#include <iostream>
using namespace std;

using ll = long long;

// Функция, которая считает количество магических чисел, не превышающих x
ll count_magic(ll x) {
    // Количество чисел, делящихся на 7: floor(x/7)
    // Количество чисел, оканчивающихся на 7: floor((x+3)/10)
    // Количество чисел, делящихся на 7 и оканчивающихся на 7: floor((x+63)/70)
    return x / 7 + (x + 3) / 10 - (x + 63) / 70;
}

int main() {
    ll k;
    cin >> k;

    // Бинарный поиск минимального x такого, что count_magic(x) >= k
    ll left = 1, right = 1e18; // правая граница выбрана с запасом
    while (left < right) {
        ll mid = left + (right - left) / 2;
        if (count_magic(mid) >= k) {
            right = mid;
        } else {
            left = mid + 1;
        }
    }

    cout << left << endl;

    return 0;
}