#include <iostream>
#include <algorithm>
using namespace std;

typedef long long ll;

// Находит первое число d в [L, R] такое, что d % k == r, и количество таких чисел
pair<ll, ll> get_first_and_count(ll L, ll R, ll r, ll k) {
    if (L > R) return {0, 0};
    ll r0 = L % k;
    ll d0 = L + ((r - r0 + k) % k);
    if (d0 > R) return {0, 0};
    ll cnt = (R - d0) / k + 1;
    return {d0, cnt};
}

int main() {
    ll n, m, k;
    cin >> n >> m >> k;
    ll a = min(n, m);
    ll b = max(n, m);
    ll total = n + m;
    ll ans[5] = {0};  // k ≤ 5

    for (ll r = 0; r < k; ++r) {
        __int128 S = 0;

        // Интервал I: [2, a]
        if (a >= 2) {
            auto p = get_first_and_count(2, a, r, k);
            ll cnt = p.second;
            if (cnt > 0) {
                ll d0 = p.first;
                S += (__int128)cnt * (d0 - 1) + (__int128)k * cnt * (cnt - 1) / 2;
            }
        }

        // Интервал II: [a+1, b]
        if (b >= a + 1) {
            auto p = get_first_and_count(a + 1, b, r, k);
            ll cnt = p.second;
            if (cnt > 0) {
                S += (__int128)a * cnt;
            }
        }

        // Интервал III: [b+1, total]
        auto p = get_first_and_count(b + 1, total, r, k);
        ll cnt = p.second;
        if (cnt > 0) {
            ll d0 = p.first;
            S += (__int128)cnt * (total + 1 - d0) - (__int128)k * cnt * (cnt - 1) / 2;
        }

        ans[r] = (ll)S;
    }

    // Вывод результатов для цветов 1..k
    for (ll c = 1; c <= k; ++c) {
        ll r = (c + 1) % k;
        cout << ans[r];
        if (c < k) cout << ' ';
    }
    cout << endl;

    return 0;
}