import sys
from math import gcd

def intersects_rect(r, a, b, c):
    v1 = a * r[0] + b * r[1] + c
    v2 = a * r[2] + b * r[1] + c
    v3 = a * r[0] + b * r[3] + c
    v4 = a * r[2] + b * r[3] + c
    if v1 > 0 and v2 > 0 and v3 > 0 and v4 > 0:
        return False
    if v1 < 0 and v2 < 0 and v3 < 0 and v4 < 0:
        return False
    return True

def check_line(rects, a, b, c):
    for r in rects:
        if not intersects_rect(r, a, b, c):
            return False
    return True

def check_vertical(rects, x):
    for r in rects:
        if x < r[0] or x > r[2]:
            return False
    return True

def check_horizontal(rects, y):
    for r in rects:
        if y < r[1] or y > r[3]:
            return False
    return True

def solve():
    try:
        data = sys.stdin.read().strip().split()
        if not data:
            return
       
        idx = 0
        t = int(data[idx])
        idx += 1
        results = []
       
        for _ in range(t):
            n = int(data[idx])
            idx += 1
            rects = []
           
            for __ in range(n):
                x1 = int(data[idx])
                y1 = int(data[idx+1])
                x2 = int(data[idx+2])
                y2 = int(data[idx+3])
                idx += 4
                rects.append((x1, y1, x2, y2))
           
            ok = False
           
            # Если только один прямоугольник - всегда Yes
            if n == 1:
                results.append("Yes")
                continue
           
            # Проверка вертикальных прямых
            for r in rects:
                if check_vertical(rects, r[0]) or check_vertical(rects, r[2]):
                    ok = True
                    break
                if check_horizontal(rects, r[1]) or check_horizontal(rects, r[3]):
                    ok = True
                    break
           
            if ok:
                results.append("Yes")
                continue
           
            # Перебор пар углов
            for i in range(n):
                if ok:
                    break
                xi1, yi1, xi2, yi2 = rects[i]
                ci = [(xi1, yi1), (xi1, yi2), (xi2, yi1), (xi2, yi2)]
               
                for j in range(i+1, n):
                    if ok:
                        break
                    xj1, yj1, xj2, yj2 = rects[j]
                    cj = [(xj1, yj1), (xj1, yj2), (xj2, yj1), (xj2, yj2)]
                   
                    for p1 in ci:
                        if ok:
                            break
                        for p2 in cj:
                            if p1[0] == p2[0] and p1[1] == p2[1]:
                                continue
                            a = p2[1] - p1[1]
                            b = -(p2[0] - p1[0])
                            c = (p2[0] - p1[0]) * p1[1] - (p2[1] - p1[1]) * p1[0]
                           
                            # Нормализация
                            g = gcd(gcd(abs(a), abs(b)), abs(c))
                            if g != 0:
                                a //= g
                                b //= g
                                c //= g
                           
                            if check_line(rects, a, b, c):
                                ok = True
                                break
           
            results.append("Yes" if ok else "No")
       
        sys.stdout.write("\n".join(results))
       
    except Exception as e:
        # В случае ошибки выводим что-то разумное
        sys.stdout.write("No\n")

if __name__ == "__main__":
    solve()