import sys

def intersects_rect(r, a, b, c):
    v1 = a * r[0] + b * r[1] + c
    v2 = a * r[2] + b * r[1] + c
    v3 = a * r[0] + b * r[3] + c
    v4 = a * r[2] + b * r[3] + c
    if v1 > 0 and v2 > 0 and v3 > 0 and v4 > 0:
        return False
    if v1 < 0 and v2 < 0 and v3 < 0 and v4 < 0:
        return False
    return True

def check_line(rects, a, b, c):
    for r in rects:
        if not intersects_rect(r, a, b, c):
            return False
    return True

def check_vertical(rects, x):
    for r in rects:
        if x < r[0] or x > r[2]:
            return False
    return True

def check_horizontal(rects, y):
    for r in rects:
        if y < r[1] or y > r[3]:
            return False
    return True

def my_gcd(a, b, c):
    from math import gcd
    return gcd(gcd(abs(a), abs(b)), abs(c))

def solve():
    input_data = sys.stdin.read().strip().split()
    if not input_data:
        return
   
    t = int(input_data[0])
    idx = 1
    results = []
   
    for _ in range(t):
        if idx >= len(input_data):
            break
        n = int(input_data[idx])
        idx += 1
        rects = []
        for __ in range(n):
            if idx + 3 >= len(input_data):
                break
            x1 = int(input_data[idx])
            y1 = int(input_data[idx+1])
            x2 = int(input_data[idx+2])
            y2 = int(input_data[idx+3])
            idx += 4
            rects.append((x1, y1, x2, y2))
       
        ok = False
       
        # Проверка вертикальных и горизонтальных прямых
        for r in rects:
            if check_vertical(rects, r[0]) or check_vertical(rects, r[2]):
                ok = True
                break
            if check_horizontal(rects, r[1]) or check_horizontal(rects, r[3]):
                ok = True
                break
       
        if ok:
            results.append("Yes")
            continue
       
        # Перебор пар углов
        for i in range(n):
            if ok: break
            ci = [
                (rects[i][0], rects[i][1]),
                (rects[i][0], rects[i][3]),
                (rects[i][2], rects[i][1]),
                (rects[i][2], rects[i][3])
            ]
            for j in range(i+1, n):
                if ok: break
                cj = [
                    (rects[j][0], rects[j][1]),
                    (rects[j][0], rects[j][3]),
                    (rects[j][2], rects[j][1]),
                    (rects[j][2], rects[j][3])
                ]
                for p1 in ci:
                    if ok: break
                    for p2 in cj:
                        if p1 == p2:
                            continue
                        a = p2[1] - p1[1]
                        b = -(p2[0] - p1[0])
                        c = (p2[0] - p1[0]) * p1[1] - (p2[1] - p1[1]) * p1[0]
                        g = my_gcd(a, b, c)
                        if g != 0:
                            a //= g
                            b //= g
                            c //= g
                        if check_line(rects, a, b, c):
                            ok = True
                            break
       
        results.append("Yes" if ok else "No")
   
    sys.stdout.write("\n".join(results))

if __name__ == "__main__":
    solve()