import sys

MOD = 10**9 + 7

def dec_to_bin(s):
    if s == '0':
        return '0'
    digits = [int(ch) for ch in s]
    bits = []
    while digits:
        rem = 0
        new_digits = []
        for d in digits:
            cur = rem * 10 + d
            new_digits.append(cur // 2)
            rem = cur % 2
        bits.append(str(rem))
        digits = []
        for d in new_digits:
            if digits or d:
                digits.append(d)
    bits.reverse()
    return ''.join(bits)

def precalc_fact(max_n):
    fact = [1] * (max_n + 1)
    for i in range(1, max_n + 1):
        fact[i] = fact[i-1] * i % MOD
    inv_fact = [1] * (max_n + 1)
    inv_fact[max_n] = pow(fact[max_n], MOD-2, MOD)
    for i in range(max_n, 0, -1):
        inv_fact[i-1] = inv_fact[i] * i % MOD
    return fact, inv_fact

def C(n, r, fact, inv_fact):
    if r < 0 or r > n:
        return 0
    return fact[n] * inv_fact[r] % MOD * inv_fact[n-r] % MOD

def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n = int(data[0])
    K = int(data[1])
    R = data[2]
   
    bin_str = dec_to_bin(R)
    L = len(bin_str)
   
    if K > L:
        print(1)
        return
   
    fact, inv_fact = precalc_fact(L)
   
    ans = 1
    for m in range(1, L):
        total = 0
        q = 1
        t = K * q - 1
        while t <= m - 1:
            total = (total + C(m - 1, t, fact, inv_fact)) % MOD
            q += 1
            t = K * q - 1
        ans = (ans + total) % MOD
   
    bits = [int(ch) for ch in bin_str]
    tight = [0] * K
    loose = [0] * K
    if bits[0] == 1:
        tight[1 % K] = 1
   
    for pos in range(1, L):
        bitR = bits[pos]
        new_tight = [0] * K
        new_loose = [0] * K
       
        for mod in range(K):
            val = tight[mod]
            if val:
                if bitR == 0:
                    new_tight[mod] = (new_tight[mod] + val) % MOD
                else:
                    new_loose[mod] = (new_loose[mod] + val) % MOD
                    nm = (mod + 1) % K
                    new_tight[nm] = (new_tight[nm] + val) % MOD
       
        for mod in range(K):
            val = loose[mod]
            if val:
                new_loose[mod] = (new_loose[mod] + val) % MOD
                nm = (mod + 1) % K
                new_loose[nm] = (new_loose[nm] + val) % MOD
       
        tight, loose = new_tight, new_loose
   
    ans = (ans + tight[0]) % MOD
    ans = (ans + loose[0]) % MOD
   
    print(ans)

if __name__ == "__main__":
    solve()



