﻿#include <iostream>
#include<vector>
#include<unordered_map>
using namespace std;
using ll = long long;
using vll = vector<ll>;

vll ssq(ll n, ll k) {
    // n == m
    vll res(k, 0);
    ll x = n / k;
    for (ll i = 1; i <= k; ++i) {
        ll l = 0, r = n;
        while (r - l > 1) {
            ll mid = (r + l) >> 1;
            if (mid * k + i <= n) l = mid;
            else r = mid;
        }
        res[i - 1] = (l * k + 2 * i) * (l + 1) / 2;
    }
    return res;
}

vll ssq(ll n, ll k, ll st) {
    // n == m
    if (st < 0) st = k - 1;
    vll res(k, 0);
    ll op = 0;
    for (ll i = st; op < k; i = (i - 1 + k) % k) {
        ll l = 0, r = n;
        while (r - l > 1) {
            ll mid = (r + l) >> 1;
            if (mid * k + i + 1 <= n) l = mid;
            else r = mid;
        }
        res[i] = (l * k + 2 * op + 2) * (l + 1) / 2;
        op++;
    }
    return res;
}

void sol() {
    ll n, m, k; cin >> n >> m >> k;
    vll ans(k, 0);
    if (n < m) swap(n, m);
    if (n == m) {
        vll r1 = ssq(n, k);
        ll st = (n + m - 1) % k - 1;
        vll r2 = ssq(n - 1, k, st);
        for (ll i = 0; i < k; ++i) {
            r1[i] += r2[i];
        }
        for (ll i : r1) cout << i << '\n';
    }
}

int main()
{
    ios::sync_with_stdio(0);
    cin.tie(0);
    sol();
    return 0;
}