﻿#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

using ll = long long;

const int INF = 1e9;

void solve() {
    int n;
    cin >> n;

    int max_x_l = 0;
    int min_x_r = INF;

    int max_y_l = 0;
    int min_y_r = INF;


    for (int i = 0; i < n; i++) {
        int x1, y1, x2, y2;
        cin >> x1 >> y1 >> x2 >> y2;

        max_x_l = max(max_x_l, x1);
        min_x_r = min(min_x_r, x2);

        max_y_l = max(max_y_l, y1);
        min_y_r = min(min_y_r, y2);
    }

    if (n <= 2) {
        cout << "Yes\n";
        return;
    }

    if (max_x_l <= min_x_r || max_y_l <= min_y_r) {
        cout << "Yes\n";
    }
    else {
        cout << "No\n";
    }
}


int main()
{
    ios_base::sync_with_stdio(false);
    cout.tie(0);
    cin.tie(0);


    int t;
    cin >> t;

    while (t--) {
        solve();
    }

}