﻿#include <iostream>
#include <vector>
#include <algorithm>
#pragma GCC optimize ("O3,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")

using namespace std;

using ll = long long;

const ll MOD = 1e9 + 7;
const int N = 2e5 + 5;

ll fact[N];
ll use[N];

ll bin_pow(ll a, ll b) {
    if (b == 0) {
        return 1;
    }

    if (b % 2 == 0) {
        return bin_pow((a * a) % MOD, b / 2);
    }

    return (bin_pow(a, b - 1) * a) % MOD;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cout.tie(0);
    cin.tie(0);


    fact[0] = 1;

    use[0] = 1;

    for (ll i = 1; i < N; i++) {
        fact[i] = (fact[i - 1] * i) % MOD;
        use[i] = bin_pow(fact[i], MOD - 2);
    }

    int n, k;
    cin >> n >> k;


    string r;
    cin >> r;

    string ans = "";

    while (true) {
        int cnt = 0;
        for (auto i : r) {
            if (i != '0') {
                cnt++;
            }
        }

        if (cnt == 0) {
            break;
        }

        if ((int)(r.back() - '0') % 2 == 1) {
            ans += '1';
        }
        else {
            ans += '0';
        }

        for (int i = 0; i < (int)r.size(); i++) {
            if ((int)(r[i] - '0') % 2 == 0) {
                int res = (int)(r[i] - '0');

                res /= 2;
                r[i] = (char)(res + '0');
            }
            else {
                int res = (int)(r[i] - '0');

                res /= 2;
                r[i] = (char)(res + '0');

                if (i == (int)r.size()) continue;

                int tmp = (int)(r[i + 1] - '0');

                tmp += 10;
                r[i + 1] = (char)(tmp + '0');
            }
        }
    }

    reverse(ans.begin(), ans.end());

    ll res = 0;
    int cnt = 0;

    for (int i = 0; i < (int)ans.size(); i++) {
        if (ans[i] == '1') {
            for (int j = 0; j <= (int)ans.size() - 1 - i; j++) {
                if ((j + cnt) % k == 0) {
                    res = (res + (fact[(int)ans.size() - 1 - i] * use[j] % MOD * use[(int)ans.size() - 1 - i - j] % MOD) % MOD) % MOD;
                }
            }
            cnt++;
        }
    }

    if (cnt % k == 0) {
        res++;
    }

    res = (res % MOD);

    cout << res;
}